@extends('sculpt!::dashboard')

@section('content')

    <h1>Welcome to SAM</h1>

    <div class="modal fade" tabindex="-1" role="dialog" id="welcome-modal" data-modal-number="3">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">SAM Update</h4>
                </div>
                <div class="modal-body">
                    <p>Hi, {{ Auth::user()->employee ? Auth::user()->employee->person->preferred_name ? Auth::user()->employee->person->preferred_name : Auth::user()->employee->person->first_name : Auth::user()->independent->name }}</p>
                    <p>
                        Over the last few weeks we've been working on SAM with some improvements and fixes.
                    </p>
                    <h5>Reset Passwords</h5>
                    <p>Coordinators and Local Administrators can now reset a user's password from within SAM.</p>
                    <p>Simply go to their profile page, click Team Member Details, then click 'Send password reset link' next to the email address. Coordinators and Local Administrators should use this as a first option when advocates are having difficulty logging into SAM.</p>
                    <h5>Contacts</h5>
                    <p>
                        When viewing contacts, it is now possible to see which people or cases those contacts are linked to, at the top of the page.
                    </p>
                    <h5>Other</h5>
                    <ul>
                        <li>All records (cases, team members, activities) now show when they were created and when they were last updated in the sidebar.</li>
                        <li>You can now click on other active users on the dashboard to go to their profile page.</li>
                        <li>Service users are now ordered alphabetically by surname rather than first name.</li>
                        <li>When adding service users, you are now redirected to the new service user page, rather than back to the list of all service users. This is the same now for cases, too.</li>
                    </ul>
                    <h5>Bug fixes</h5>
                    <ul>
                        <li>Fixed a bug causing error messages on the login page from being hidden. Now, messages will be shown when a login doesn't go through for whatever reason.</li>
                        <li>Fixed bug where link to add activities on the homepage was broken.</li>
                        <li>Users can now reply to the welcome emails they receive from SAM in order to submit a support request. Previously these came from 'noreply@opaalsam.org.uk'.</li>
                        <li>Fixed notes content not auto-expanding when adding content.</li>
                        <li>Fixed bug where the duration of activities wasn't accurately reflecting the duration of individual timeslots.</li>
                        <li>Fixed a bug where reports showed a blank row instead of 'Other' for 'Activities by what they involved' table.</li>
                    </ul>
                    <p>Please continue to provide feedback and report problems, and we will maintain to find fixes and improvements to the system ongoing.</p>
                </div>
                <div class="modal-footer" style="text-align:left;margin-top:0;">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Take me to SAM</button>
                </div>
            </div>
        </div>
    </div>
    @section('body-end')
        @parent
        <script>
            $modal = $('#welcome-modal');
            if(typeof Cookies.get('last-welcome-modal-seen') === 'undefined' || Cookies.get('last-welcome-modal-seen') < $modal.attr('data-modal-number')) {
                setTimeout(function() {
                    $('#welcome-modal').modal();
                },500);
                $('#welcome-modal').on('hidden.bs.modal', function (e) {
                    Cookies.set('last-welcome-modal-seen',$modal.attr('data-modal-number'));
                });
            }
        </script>
    @stop

    @if(count($reminders))
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Reminders
                </h3>
            </div>
            @include('reminders::list',['reminders' => $reminders])
        </div>
    @endif

    @if(count($recent_activities))
        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title">Recent Activities</h3>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:activities','see:activities-show']))
                            <a href="{{ route('sculpt.index','activities') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all activities</a>
                        @endif
                        @if(Auth::user()->can(['see:activities','see:activities-create']))
                            <a href="{{ route('sculpt.create','activities') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New activity</a>
                        @endif
                    </div>
                </div>
            </div>
            @include('sculpt::activities.partials.table',['activities' => $recent_activities])
        </div>
    @endif

    @if(Auth::user()->can('see:all-cases'))

        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title" style="display:inline-block;">
                    <i class="fa fa-fw fa-warning"></i>
                    {{ singular_plural(count($cases_without_advocates),'Unassigned Case','Unassigned Cases') }}
                </h3>
                <span data-toggle="popover" data-trigger="hover" data-content="<p>This shows cases that are open or have yet to be opened with no advocate(s) assigned. Cases that have been open and later closed are not shown, nor are cases with 'No advocate needed' checked.</p><p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </div>
            @if(count($cases_without_advocates))
                @include('sculpt::service-user-cases.partials.table',['cases' => $cases_without_advocates,'classes' => 'table-condensed'])
            @else
                <div class="panel-body">
                    No unassigned cases.
                </div>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:employees'))

        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title" style="display:inline-block;">Caseload</h3>
                        <span data-toggle="popover" data-trigger="hover" data-content="<p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p><p>Average cases per advocate: {{ round($average_cases_per_advocate,0) }}</p>" class="text-muted">
                            <i class="fa fa-fw fa-info-circle"></i>
                        </span>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-show']))
                            <a href="{{ route('sculpt.index','service-user-cases') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all cases</a>
                        @endif
                        @if(Auth::user()->can(['see:service-users','see:service-users-create']))
                            <a href="{{ route('sculpt.create','service-users') }}" class="btn btn-default btn-sm"><i class="fa fa-plus"></i> New service user</a>
                        @endif
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-create']))
                            <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New case</a>
                        @endif
                    </div>
                </div>
            </div>
            @if(count($advocates_with_cases))
                <div class="row" style="margin:0;">
                    <?php $i = 1; ?>
                    @foreach($advocates_with_cases as $advocate)
                        <?php $open_cases = $advocate->cases; ?>
                        <div class="col-sm-6" style="padding:0;{!! $i % 2 === 1 ? " clear:both;" : '' !!}">
                            <table class="table" style="margin-bottom:0;">
                                <thead>
                                    <tr>
                                        <th colspan="6">
                                            <a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a>
                                            ({{ singular_plural(count($open_cases), 'open case', 'open cases') }})
                                            <?php $days = $advocate->employee->user->daysSinceLastActivity(); ?>
                                            @if($days)
                                                <small data-toggle="tooltip" title="{{ $advocate->employee->person->preferred_name ?: $advocate->employee->person->first_name }}'s last activity was 3 days ago" class="text-muted" style="font-weight:normal; float:right; line-height:1.7;">
                                                    <i class="fa fa-fw fa-calendar-o"></i> {{ $days }} days ago
                                                </small>
                                            @endif
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php $j = 1; ?>
                                        @foreach($open_cases as $case)
                                            {!! $j % 2 === 1 ? "</tr><tr>" : '' !!}
                                            <td>
                                                <a href="{{ $case->getUrl() }}" style="color:inherit;"><small>{{ $case->name }}</small></a>
                                            </td>
                                            <td width="2px" align="right" style="padding:0;">
                                                <a style="padding:8px; display:block;" href="{{ route('sculpt.create',['activities','service_user_case_id' => $case->id]) }}" title="New activity for {{ $case->service_user->name }}">
                                                    <small class="text-muted">
                                                        <i class="fa fa-plus"></i>
                                                    </small>
                                                </a>
                                            </td>
                                            <td width="40px" align="right" style="padding-left:0px;">
                                                <?php $days = $case->daysSinceLastActivity(); ?>
                                                @if($days)
                                                    <small class="text-muted" data-toggle="tooltip" title="{{ $case->service_user->person->preferred_name ?: $case->service_user->person->first_name }}'s last activity was {{ $days }} days ago">
                                                        <i class="fa fa-calendar-o" style="margin-right:2px;"></i>
                                                        {{ $days }}
                                                    </small>
                                                @endif
                                            </td>
                                            <?php $j++; ?>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <?php $i++; ?>
                    @endforeach
                </div>
            @else
                <div class="panel-body">
                    No active advocates with open cases.
                </div>
            @endif
            @if(count($advocates_without_cases))
                <table class="table text-muted">
                    <thead>
                        <tr>
                            <th colspan="4">{{ singular_plural(count($advocates_without_cases),'active advocate','active advocates') }} with no open cases</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <?php $k = 1; ?>
                            @foreach($advocates_without_cases as $advocate)
                                {!! $k % 4 === 1 ? "</tr><tr>" : '' !!}
                                <td width="25%"><a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a></td>
                                <?php $k++; ?>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:logged-in-users'))
        @include('sculpt::active-users')
    @endif

    @if(Auth::user()->can('see:all-cases') && AuditLog::has())
        <small class="text-muted">
            @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::paginate(10)])
        </small>
    @endif

@stop