<h1>Add new local team member</h1>

<p>New advocates, coordinators and local administrators are all added in the same way. First, personal information is entered such as name and contact information, and then the relevant role is added and the user is activated.</p>

<div class="panel panel-default screen-only">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-list"></i> Contents</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item"><a href="#_create">Create a team member</a></li>
        <li class="list-group-item"><a href="#_activate">Activating a role</a></li>
        <li class="list-group-item"><a href="#_deactivate">Deactivating a role</a></li>
    </ul>
</div>

<section id="_create">

    <div class="no-break">
        <h2>Create a team member</h2>
        <p>First, we need to create a team member record. In this example, we'll be creating a record for new advocate <em>Sally Smith</em>.</p>
    </div>

    <div class="no-break">
        <h4>Step 1</h4>
        <p>First, ensure we're in the Local Team section by clicking <strong>Local Team</strong> in the main navigation.</p>
    </div>

    <div class="no-break">
        <h4>Step 2</h4>
        <p>Now click <strong><i class="fa fa-plus"></i> Add new local team member</strong> in the sidebar.</p>
    </div>

    <div class="no-break">
        <h4>Step 3</h4>
        <p>From here we can enter Sally's name, contact details and demographic information.</p>
    </div>

    <p class="alert alert-warning">
        <i class="fa fa-exclamation-triangle"></i> To ensure SAM's database of information is as up to date as possible, please make sure to include all information to hand about the team member, and come back to the record later to fill in any other information once it is learned.
    </p>

    <p>
        If Sally has access to a car and a clean driving license, this information can be added on the <strong>Team Member Details</strong> tab.
    </p>

    <p>
        Any additional notes and key contacts can also be added to Sally's record here, under the <strong>Notes and Milestones</strong> and <strong>Contacts</strong> tabs.
        For more info, see {!! link_to("$this/notes",'Notes') !!} or {!! link_to("$this/contacts",'Contacts') !!}.</a>
    </p>

    <p>Once these details have been entered, click <strong><i class="fa fa-floppy-o"></i> Add local team member</strong> to save.</p>

    <p class="alert alert-warning">
        <i class="fa fa-exclamation-triangle"></i> After saving, Sally has been entered into the system, but she currently has no role. To give her a role (e.g. advocate), see below.
    </p>

</section>

<section id="_activate">

    <div class="no-break">
        <h2>Activating a Role</h2>
        <p class="alert alert-info">
            For more information on which roles are appropriate for which team members, see {!! link_to("$docs/local-team/roles",'Local team roles and access rights') !!}.
        </p>
        <h4>Step 1</h4>
        <p>First, {!! link_to("$docs/finding-information#_team_member",'find the local team member page') !!}.</p>
    </div>

    <div class="no-break">
        <h4>Step 2</h4>
        <p>From the team member page, click the <strong>Team Member Details</strong> tab.</p>
    </div>

    <p>Inside the <strong>Role History</strong> box, choose the role from the dropdown provided, for example 'Advocate'.</p>

    <div class="no-break">
        <h4>Step 3</h4>
        <p>When attaching roles to team members, SAM may ask for more information such as the type of advocate, preferred area of work, etc. These fields are dependent on the role being added.</p>
    </div>

    <p>If there are any additional fields to fill out for this role, we'll see a screen titled (for example) <strong>Attach Advocate Role</strong>. Fill out the fields on this page and click <strong><i class="fa fa-floppy-o"></i> Attach Advocate Role</strong> in the sidebar when done.</p>

    <p>After doing this, we'll see the success message 'Active period started successfully'. This means that Sally is now an active advocate in the system.</p>

    <p>If Sally has a login email defined on her record (in the <strong>Team Member Details</strong> tab under <strong>User Details</strong>), she will now be able to login.</p>

    <p class="alert alert-warning">
        <i class="fa fa-exclamation-triangle"></i> Team members can only login if they have a login email defined. If Sally does not have a login email defined, she can still be treated as any other advocate (cases can be assigned to her, etc) but she won't be able to login herself.
    </p>

</section>

<section id="_deactivate">

    <div class="no-break">
        <h2>Deactivating a Role</h2>
        <p>Sometimes we may want to remove the status of advocate (or coordinator, cancer champion, local administrator) from a particular team member. In these situations, we need to deactivate the appropriate role.</p>
    </div>

    <div class="no-break">
        <h4>Step 1</h4>
        <p>First, {!! link_to("$docs/finding-information#_team_member",'find the local team member') !!}.</p>
    </div>

    <div class="no-break">
        <h4>Step 2</h4>
        <p>From the team member page, click the <strong>Team Member Details</strong> tab. From here we can see all roles that this team member currently has or has ever had. Active roles are ones with no deactivation date with a link that says <strong>Deactivate now</strong>.</p>
    </div>

    <div class="no-break">
        <h4>Step 3</h4>
        <p>In order to deactivate a particular role, click <strong>Deactivate now</strong>. For some roles, such as the advocate, we will be asked your reason for deactivating the role. Select this and then click <strong>Deactivate</strong> to confirm.</p>
    </div>

    <p>This team member's role has now been deactivated. If we need to deactivate more roles, we can do so in the same way.</p>

    <p class="alert alert-warning">
        <i class="fa fa-fw fa-exclamation-triangle"></i> <strong>Note:</strong> If a user has no active roles, they will be unable to login to SAM. A warning to this effect is shown on a team member's record when this is the case.
    </p>

</section>