<h1>Local Team roles and permissions</h1>

<div class="panel panel-default screen-only">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-fw fa-list"></i> Contents</h3>
    </div>
    <ul class="list-group">
        <li class="list-group-item"><a href="#_roles">Roles</a></li>
        <li class="list-group-item"><a href="#_permissions">Permissions table</a></li>
    </ul>
</div>

<p>There are several different roles that team members can have in SAM. Team members can also have multiple roles, if this is appropriate. Different roles give users permission to perform different kinds of tasks within SAM.</p>

<section id="_roles">

    <div class="no-break">
        <h2>Roles</h2>
        <h3>Local Administrators</h3>
        <p>Local administrators can see all cases in an organisation, open and close cases, and add new advocates to the system, add new coordinators to the system, and view reports.</p>
    </div>

    <div class="no-break">
        <h3>Coordinators</h3>
        <p>Coordinators have identical permissions to local administrators, except they cannot add other coordinators to the system.</p>
    </div>

    <div class="no-break">
        <h3>Advocates</h3>
        <p>Advocates have the most limited access of all roles. They can log activities with cases that are assigned to them and see and update information for those cases. Advocates are unable to add new cases or see other advocates' cases.</p>
    </div>

    <div class="no-break">
        <h3>Cancer Champions</h3>
        <p>The cancer champion role does not provide any additional permissions in SAM, and is purely present in order to collect data on the number of cancer champions and their demographics.</p>
    </div>

    <p>For information on adding roles, see {!! link_to("$docs/local-team/create-activate-deactivate#_activate",'Activate a role') !!}.</p>

</section>

<section id="_permissions" class="no-break">
    <h2>Permissions table</h2>
    <p>The below table summarises the permissions for each user role.</p>
    <table class="table table-condensed table-bordered">
        <thead>
        <th width="150"></th>
        <th>Can see details for</th>
        <th>Can modify details for</th>
        <th>Can add new</th>
        <th>Can activate/open</th>
        <th>Can deactivate/close</th>
        <th>Can see identifying information</th>
        <th>Can view reports</th>
        </thead>
        <tbody>
        <tr{!! Auth::user()->hasRole('advocate') ? " class='info'" : null !!}>
            <td>Advocate{!! Auth::user()->hasRole('advocate') ? "<br /><span class='text-info'>(You have this role)</span>" : null !!}</td>
            <td colspan="2">Cases and service users assigned to them</td>
            <td colspan="3">None</td>
            <td>Yes</td>
            <td>No</td>
        </tr>
        <tr{!! Auth::user()->hasRole('coordinator') ? " class='info'" : null !!}>
            <td>Coordinator{!! Auth::user()->hasRole('coordinator') ? "<br /><span class='text-info'>(You have this role)</span>" : null !!}</td>
            <td colspan="3">Cases, service users, advocates and coordinators</td>
            <td colspan="2">Cases and advocates</td>
            <td>Yes</td>
            <td>Yes</td>
        </tr>
        <tr{!! Auth::user()->hasRole('manager') ? " class='info'" : null !!}>
            <td>Local Administrator{!! Auth::user()->hasRole('manager') ? "<br /><span class='text-info'>(You have this role)</span>" : null !!}</td>
            <td colspan="3">Cases, service users, advocates and coordinators</td>
            <td colspan="2">Cases, advocates and coordinators</td>
            <td>Yes</td>
            <td>Yes</td>
        </tr>
        <tr{!! Auth::user()->hasRole('admin') ? " class='info'" : null !!}>
            <td>Administrator{!! Auth::user()->hasRole('admin') ? "<br /><span class='text-info'>(You have this role)</span>" : null !!}</td>
            <td colspan="5">All data</td>
            <td>Yes</td>
            <td>Yes</td>
        </tr>
        <tr{!! Auth::user()->hasRole('observer') ? " class='info'" : null !!}>
            <td>Observer{!! Auth::user()->hasRole('observer') ? "<br /><span class='text-info'>(You have this role)</span>" : null !!}</td>
            <td colspan="2">All data</td>
            <td colspan="3">None</td>
            <td>No</td>
            <td>Yes</td>
        </tr>
        </tbody>
    </table>
</section>