<table class="table table-striped table-hover service-user-cases-table{{ isset($classes) ? ' ' . $classes : '' }}">
    <thead>
    <tr>
        <th>Case</th>
        <th>Status</th>
        <th>Date Opened</th>
        <th>Date Closed</th>
        <th>Last Updated</th>
    </tr>
    </thead>
    @if(count($cases))
        @foreach($cases as $case)
            <tr data-href="{{ route('sculpt.show',['service-user-cases',$case->id]) }}" class="{{ !$case->latest_active_period || $case->latest_active_period->end ? 'text-muted' : '' }}">
                <td>{{ $case->name }}</td>
                @if(!$case->latest_active_period || $case->latest_active_period->end)
                    <td class="text-warning">
                        <i class="fa fa-fw fa-folder-o"></i>
                        Closed
                    </td>
                @else
                    <td class="text-success">
                        <i class="fa fa-fw fa-folder-open-o"></i>
                        Open
                    </td>
                @endif
                @if(!$case->latest_active_period)
                    <td class="text-muted">Never opened</td>
                    <td></td>
                @else
                    <td>{{ $case->latest_active_period->start->format('jS F Y') }}</td>
                    <td>
                        @if($case->latest_active_period->end)
                            {{ $case->latest_active_period->end->format('jS F Y') }}
                        @endif
                    </td>
                @endif
                <td>{{ $case->updated_at->format('jS F G:i:s') }}</td>
            </tr>
        @endforeach
    @else
        <tr><td colspan="5">No cases to show.</td></tr>
    @endif
</table>
