@extends('sculpt::auto.index')

@section('title')
    <h1>
        {!! Config::get('sculpt.icon-' . $model->getSlugged()) !!}
        {{ Sculpt::getTrans('index-title',$model->getHumanReadablePlural()) }}
    </h1>
    <p>Service users are individuals supported by the programme.</p>
@stop

@section('table')
    <table class='table table-striped table-hover'>
        @section('table-head')
            <thead>
            <th>Name</th>
            <th width="70">Cases</th>
            <th width="150">Has open case?</th>
            </thead>
        @show
        @foreach($records as $record)
            <tr data-href="{{ route('sculpt.show',['service-users',$record->id])  }}">
                @if($record->isActive())
                    <td>
                        {!! $record->name !!}
                    </td>
                    <td>
                        {!! $record->cases()->count() !!}
                    </td>
                    <td width="20" class="text-success">
                        <i class="fa fa-fw fa-folder-open-o"></i> Yes
                    </td>
                @else
                    <td class="text-muted">
                        {!! $record->name !!}
                    </td>
                    <td>
                        {!! $record->cases()->count() !!}
                    </td>
                    <td width="20" class="text-warning">
                        <i class="fa fa-fw fa-folder-o"></i> No
                    </td>
                @endif
            </tr>
        @endforeach
    </table>
@stop