<?php namespace Concore\Sam\Handlers\Events;

use AuditLog;
use Concore\Personnel\Handlers\Events\LogActivePeriodStarted as ParentClass;
use Concore\Personnel\Events\ActivePeriodStarted;

class LogActivePeriodStarted extends ParentClass {

    /**
     * Handle the event.
     *
     * @param  ActivePeriodStarted  $event
     * @return void
     */
    public function handle(ActivePeriodStarted $event)
    {
        if ($this->is_of_type($event->attach_to,'Concore\Sam\Models\ServiceUserCase')) {
            $this->audit_log_service->put('opened-case',$event->attach_to);
        }
        else {
            parent::handle($event);
        }
    }

}

