<?php namespace Concore\Sam\Http\Controllers;

use Redirect, Carbon\Carbon, Auth;
use Illuminate\Http\Request;
use Concore\Personnel\Models\Organisation;
use Concore\Reports\Services\ReportsService;

class ReportsController extends \Concore\Reports\Http\Controllers\ReportsController {

    public function __construct(Organisation $organisation) {
        $this->organisation_model = $organisation;
    }

    public function show(
        Request $request,
        ReportsService $reports_service,
        $key = null
    ) {
        // If no dates specified redirect to show last month
        if(!($request->has('from_month') && $request->has('from_year') && $request->has('to_month') && $request->has('to_year'))) {
            $now = Carbon::now();
            $args = [];
            $args[] = 'to_month=' . $now->format('m');
            $args[] = 'to_year=' . $now->format('Y');
            $now->subMonth();
            $args[] = 'from_month=' . $now->format('m');
            $args[] = 'from_year=' . $now->format('Y');
            return Redirect::to($_SERVER['REQUEST_URI'] . '?' . implode('&',$args));
        }
        return parent::show($request, $reports_service, $key);
    }

    public function showWith() {
        $with = parent::showWith();
        if (Auth::user()->can('see:all-organisations')) {
            $with['organisations'] = ['' => ''] + $this->organisation_model->lists('name', 'id');
        }
        return $with;
    }

    protected function setParameters($show_report, $request) {
        if (Auth::user()->can('see:all-organisations')) {
            if ($request->input('organisation')) {
                $show_report->setOrganisation($request->input('organisation'));
            }
        }
        else {
            $show_report->setOrganisation(Auth::user()->getOrganisationId());
        }
        return parent::setParameters($show_report, $request);
    }

}