<?php namespace Concore\Sam\Models;

use Auth;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class ServiceUser extends Model implements IdentifiableInterface {

    use IdentifiableTrait;

    protected $guarded = ['id','created_at','updated_at'];

    public $name_field = 'first_name';

    public $relation_methods = ['person'];

    public $removed_validation_rules = ['person_id'];

    public function person() {
        return $this->belongsTo(app('Concore\Personnel\Models\Person'));
    }

    public function cases() {
        return $this->hasMany(app('Concore\Sam\Models\ServiceUserCase'));
    }

    public function getNameAttribute() {
        if(Auth::user()->can('see:identifying-information')) {
            return $this->person->name;
        } else {
            return 'Service User #' . $this->id;
        }
    }

    public function isActive() {
        foreach($this->cases as $case) {
            if($case->isActive()) {
                return true;
            }
        }
        return false;
    }

    public function notes() {
        return $this->person->notes();
    }

    public function scopeInOrganisation($query, $organisation_id) {
        return $query->whereHas('person',function($query) use($organisation_id) {
            $query->where('organisation_id','=',$organisation_id);
        });
    }

}
