<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\ActivePeriod;

abstract class MasterRoleReport implements SamReportableInterface
{

    use IdentifiableTrait;
    use ReportableTrait {
        getDates as getDatesTrait;
        ReportableTrait::getUrl insteadof IdentifiableTrait;
    }
    use SamReportableTrait;

    public function getStartOfPeriodTable() {
        if (is_null($this->from)) {
            if (is_null($this->first)) {
                $this->getDates();
            }
            $from = $this->first;
        }
        else {
            $from = $this->from;
        }
        if (is_null($this->to)) {
            if (is_null($this->last)) {
                $this->getDates();
            }
            $to = $this->last;
        }
        else {
            $to = $this->to;
        }
        $query = $this->getBaseQuery();
        $active_at_start = $query->withActivePeriods($this->role_name, function($active_period) use ($from, $to) {
            return $active_period
                ->where('start','<',$from->format('Y-m-d'))
                ->where(function($q) use ($from) {
                    $q->whereNull('end')
                        ->orWhere('end','>=',$from->format('Y-m-d'));
                });
        })->count();

        $query = $this->getBaseQuery();
        $never_activated_at_start = $query->withActivePeriods($this->role_name, function($active_period) use ($from) {
            return $active_period->where('start','<',$from->format('Y-m-d'));
        },'<',1)->count();

        $query = $this->getBaseQuery();
        $inactive_at_start = $query->withActivePeriods($this->role_name, function($active_period) use ($from) {
            return $active_period->where('end','<',$from->format('Y-m-d'));
        })->withActivePeriods($this->role_name, function($active_period) use ($from) {
            return $active_period
                ->where('start','<',$from->format('Y-m-d'))
                ->where(function($q) use ($from) {
                    $q->whereNull('end')
                        ->orWhere('end','>=',$from->format('Y-m-d'));
                });
        },'<',1)->count();

        return new Table(
            'Start of period',
            [],
            [
                [
                    $this->start_during_end_wording[0][0],
                    $active_at_start
                ],
                [
                    $this->start_during_end_wording[0][1],
                    $never_activated_at_start
                ],
                [
                    $this->start_during_end_wording[0][2],
                    $inactive_at_start
                ]
            ]
        );
    }

    public function getDuringPeriodTable() {
        if (is_null($this->from)) {
            if (is_null($this->first)) {
                $this->getDates();
            }
            $from = $this->first;
        }
        else {
            $from = $this->from;
        }
        if (is_null($this->to)) {
            if (is_null($this->last)) {
                $this->getDates();
            }
            $to = $this->last;
        }
        else {
            $to = $this->to;
        }
        // Get active periods that are the first for their case and are opened within the period
        $query = $this->getActivePeriodBaseQuery();
        $case_openings = $query->where('start', '>=', $from->format('Y-m-d'))->where('start', '<=', $to->format('Y-m-d'))->where('is_first',true)->count();
        // Get active periods that are not the first for their case, that are opened within the period
        $query = $this->getActivePeriodBaseQuery();
        $case_reopenings = $query->where('start', '>=', $from->format('Y-m-d'))->where('start', '<=', $to->format('Y-m-d'))->where('is_first',false)->count();
        // Get active periods that end within the period
        $query = $this->getActivePeriodBaseQuery();
        $case_closings = $query->where('end', '>=', $from->format('Y-m-d'))->where('end', '<=', $to->format('Y-m-d'))->count();
        return new Table(
            'During period',
            [],
            [
                [
                    $this->start_during_end_wording[1][0],
                    $case_openings
                ],
                [
                    $this->start_during_end_wording[1][1],
                    $case_reopenings
                ],
                [
                    $this->start_during_end_wording[1][2],
                    $case_closings
                ]
            ]
        );
    }

    public function getEndOfPeriodTable() {
        if (is_null($this->from)) {
            if (is_null($this->first)) {
                $this->getDates();
            }
            $from = $this->first;
        }
        else {
            $from = $this->from;
        }
        if (is_null($this->to)) {
            if (is_null($this->last)) {
                $this->getDates();
            }
            $to = $this->last;
        }
        else {
            $to = $this->to;
        }

        $query = $this->getBaseQuery();
        $active_at_end = $query->withActivePeriods($this->role_name, function($active_period) use ($to) {
            return $active_period
                ->where('start','<=',$to->format('Y-m-d'))
                ->where(function($q) use ($to) {
                    $q->whereNull('end')
                        ->orWhere('end','>',$to->format('Y-m-d'));
                });
        })->count();

        $query = $this->getBaseQuery();
        $never_active_at_end = $query->withActivePeriods($this->role_name, function($active_period) use ($to) {
            return $active_period->where('start','<=',$to->format('Y-m-d'));
        },'<',1)->count();

        $query = $this->getBaseQuery();
        $inactive_at_end = $query->withActivePeriods($this->role_name, function($active_period) use ($to) {
            return $active_period
                ->where('end','<=',$to->format('Y-m-d'));
        })->withActivePeriods($this->role_name, function($active_period) use ($to) {
            return $active_period
                ->where('start','<=',$to->format('Y-m-d'))
                ->where(function($q) use ($to) {
                    $q->whereNull('end')
                        ->orWhere('end','>',$to->format('Y-m-d'));
                });
        },'<',1)->count();

        return new Table(
            'End of period',
            [],
            [
                [
                    $this->start_during_end_wording[2][0],
                    $active_at_end
                ],
                [
                    $this->start_during_end_wording[2][1],
                    $never_active_at_end
                ],
                [
                    $this->start_during_end_wording[2][2],
                    $inactive_at_end
                ]
            ]
        );
    }

}