<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ActivePeriod;

class VolunteerAdvocatesReport extends EmployeesReport {
    protected $role_name = 'advocate';
    public function getNameAttribute() {
        return 'Volunteer Advocates';
    }
    protected function getBaseUrlArgs() {
        $args = parent::getBaseUrlArgs();
        $args['advocate_type'] = 'Volunteer';
        return $args;
    }
    protected function getBaseQuery() {
        $query = parent::getBaseQuery();
        return $query->whereHas('advocate',function($query) {
            $query->where('type_of_advocate','=','Volunteer');
        });
    }

    protected function getActivePeriodBaseQuery() {
        $query = $this->active_period->whereHas('role',function($role) {
            $role->where('name','=',$this->role_name);
        });
        $query = $query->whereHas('employee', function($query) {
            if (!is_null($this->organisation_id)) {
                $query->inOrganisation($this->organisation_id);
            }
            $query->whereHas('advocate',function($query) {
                $query->where('type_of_advocate','=','Volunteer');
            });
        });
        return $query;
    }
}