<?php namespace Concore\Sam\Services\Sculpt;

use Session, AuditLog, Auth;
use Concore\Sculpt\Services\Interfaces\SculptModelServiceInterface;
use Concore\Sculpt\Services\SculptModelService;

class AdvocateService extends SculptModelService implements SculptModelServiceInterface {

    public function getActiveOrderedByOpenCases() {
        if(!$this->model) {
            $this->model = app('Concore\Sam\Models\Advocate');
        }
        $query = $this->model->active()->hasOpenCases();
        if(!Auth::user()->can('see:all-organisations')) {
            $query = $query->inOrganisation(Auth::user()->getOrganisationId());
        }
        $query = $query->with(['cases' => function($query) {
            return $query->whereHas('active_periods',function($query) {
                $query->whereNull('end');
            });
        }]);
        return $query->get()->sortBy(function($advocate) {
            return $advocate->cases->count();
        },SORT_REGULAR,true);
    }

    public function getActiveNoOpenCases() {
        if(!$this->model) {
            $this->model = app('Concore\Sam\Models\Advocate');
        }
        $query = $this->model->active()->noOpenCases();
        if(!Auth::user()->can('see:all-organisations')) {
            $query = $query->inOrganisation(Auth::user()->getOrganisationId());
        }
        return $query->get();
    }

}