<?php namespace Concore\Sam\Services;

use Auth;
use Concore\Personnel\Services\TasksService as ParentClass;
use Concore\Sam\Models\Task;

class TasksService extends ParentClass {

    /**
     * @var Task
     */
    protected $task;

    public function __construct(Task $task) {
        $this->task = $task;
    }

    public function getRecent($n = 5) {
        if(!$this->task) {
            $this->task = app('Concore\Sam\Models\Task');
        }
        $query = $this->task->query();
        if(Auth::user()->hasRole('advocate') && !Auth::user()->can('see:all-activities')) {
            $query = $query->whereHas('service_user_case',function($query) {
                $query->forAdvocate(Auth::user()->employee->advocate->id);
            });
        }
        if(!Auth::user()->can('see:all-organisations')) {
            $query = $query->inOrganisation(Auth::user()->getOrganisationId());
        }
        $query = $query->orderBy('created_at','desc');
        return $query->take($n)->get();
    }

    public function getBetween($from, $to) {
        $query = parent::getBetween($from, $to);
        if(Auth::user()->hasRole('advocate') && !Auth::user()->can('see:all-activities')) {
            $query = $query->whereHas('service_user_case',function($query) {
                $query->forAdvocate(Auth::user()->employee->advocate->id);
            });
        }
        return $query;
    }

}