<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSexualityFieldToPeopleTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('people', function(Blueprint $table)
        {
            $table->integer('sexuality_id')->unsigned()->nullable()->after('gender_id');
            $table->foreign('sexuality_id')->references('id')->on('sexualities')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('people', function(Blueprint $table)
        {
            $table->dropForeign('people_sexuality_id_foreign');
            $table->dropColumn('sexuality');
        });
    }

}
