<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCaseTypeToCases extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->enum('case_type',['Patient','Carer'])->default('Patient')->after('service_user_id');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->dropColumn('case_type');
		});
	}

}
