@extends('reports::partials.tab-content')

@section('report-tab-panel')
    <p class="alert alert-info"><strong>Note:</strong> this includes all activities whose date is within the time period for this report. Some of these may be for cases added during a previous time period, and for this reason the numbers are not directly comparable with the Service User Cases report. For information specifically on the support received for cases added during this period, see the Service User Cases report.</p>
    <h3>{{ $tables['activities_totals_table']->getTitle() }}</h3>
    @include('reports::partials.table',['table' => $tables['activities_totals_table']])
    <h3>{{ $tables['individual_activity_totals_table']->getTitle() }}</h3>
    @include('reports::partials.table',['table' => $tables['individual_activity_totals_table']])
    <h3>
        {{ $tables['timeslot_totals_table']->getTitle() }}
    </h3>
    @include('reports::partials.table',['table' => $tables['timeslot_totals_table']])
    <small>
        <p class="text-muted"><strong>Activities by what they involved example:</strong> For Letter writing, the figures are as follows:</p>
        <ul class="text-muted">
            <li><strong>Number of activities</strong> - how many activities involved letter writing</li>
            <li><strong>Total activity duration</strong> - total amount of these activities as a whole (including time spent on other things like emails, travel)</li>
            <li><strong>Average activity duration</strong> - average amount of these activities as a whole</li>
            <li><Strong>Total timeslot duration</Strong> - total amount of time actually spent letter writing across these activities</li>
            <li><strong>Average timeslot duration</strong> - average amount of time actually spent letter writing across these activities</li>
            <li><strong>Affected cases</strong> - how many cases these activities are spread across</li>
        </ul>
    </small>
@stop

@section('head-after-style')
    @parent
    <style>
        #totals                             tr td:last-child {
            width: 200px;
        }
        #activities-by-nature               tr td:nth-last-child(-n + 4),
        #activities-by-what-they-involved   tr td:nth-last-child(-n + 4) {
            width:100px;
        }
    </style>
@stop
