@if(count($active_sessions))
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Other Active Users</h3>
        </div>
        <div class="panel-body">
            <ul>
                @foreach($active_sessions as $session)
                    <li>
                        @if(Config::get('sculpt.sessions.other_active_users.show_name'))
                            <a href="{{ $session->user->employee->getUrl() }}">{{ $session->user->name }}</a>
                        @else
                            <a href="{{ $session->user->employee->getUrl() }}">User #{{ $session->user->id }}</a>
                        @endif
                        at {{ $session->user->employee->person->organisation->name }}
                        @if(Config::get('sculpt.sessions.other_active_users.show_last_active'))
                            @if(Config::get('sculpt.sessions.other_active_users.last_active_click_to_url'))
                                <a href="{{ $session->last_url }}"><small class="text-muted">last active {{ $session->last_activity_relative }}</small></a>
                            @else
                                <small class="text-muted">last active {{ $session->last_activity_relative }}</small>
                            @endif
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endif