<table class='table table-striped table-hover activities-table{{ isset($classes) ? ' ' . $classes : '' }}' style="margin-bottom:0;">
    @section('table-head')
        <thead>
        <th>Case</th>
        <th>Name</th>
        <th></th>
        <th>Undertaken by</th>
        <th>Date</th>
        </thead>
    @show
    @if(!count($activities))
        <tr><td colspan="5" class="text-muted">No activities to show</td></tr>
    @else
        @foreach($activities as $record)
            <tr data-href="{{ route('sculpt.show',['activities',$record->id])  }}">
                <td>
                    {!! $record->service_user_case ? $record->service_user_case->name : null !!}
                </td>
                <td>
                    {!! $record->name !!}
                </td>
                <td width="100" align="right">
                    @if($record->outcome && Auth::user()->can('see:identifying-information'))
                        <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="{{ nl2br($record->getOutcomeSummary()) }}" class="text-muted">
                            <i class="fa fa-fw fa-eye"></i> Preview
                        </span>
                    @endif
                </td>
                <td>{{ $record->user ? $record->user->name : '' }}</td>
                <td>{{ $record->date->format('jS F Y') }}</td>
            </tr>
        @endforeach
    @endif
</table>