@extends('sculpt::auto.index')

@section('title')
    <h1>
        {!! Config::get('sculpt.icon-' . $model->getSlugged()) !!}
        {{ Sculpt::getTrans('index-title',$model->getHumanReadablePlural()) }}
    </h1>
    <p>Cases are attached to service users, and advocates are assigned to cases.</p>
@stop

@section('filter-form')
    @if(Auth::user()->can('see:all-cases'))
        <div class="panel panel-default">
            {!! Form::open(['method' => 'get','class' => 'form-horizontal does-not-cause-unsaved-changes']) !!}
            <div class="panel-body" style="padding-bottom:0;">
                <div class="row">
                    <div class="col-sm-2">
                        <div class="form-group form-group-sm">
                            {!! Form::label('id','ID',['class' => 'col-sm-2 control-label']) !!}
                            <div class="col-sm-9">
                                {!! Form::text('id',isset($filters['id']) ? $filters['id'] : null,['class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                    @if(Auth::user()->can('see:identifying-information'))
                        <div class="col-sm-5">
                            <div class="for-group form-group-sm">
                                {!! Form::label('name','Name',['class' => 'col-sm-2 control-label']) !!}
                                <div class="col-sm-10">
                                    {!! Form::text('name',isset($filters['name']) ? $filters['name'] : null,['class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="col-sm-5" style="padding-left:0;">
                        <div class="checkbox">
                            <strong style="margin-right:4px;">Show cases:</strong>
                            <label style="margin-right:4px;">
                                {!! Form::checkbox('show_open',true,isset($filters['show_open']) && $filters['show_open']) !!}
                                Open
                            </label>
                            <label style="margin-right:4px;">
                                {!! Form::checkbox('show_closed',true,isset($filters['show_closed']) && $filters['show_closed']) !!}
                                Closed
                            </label>
                            <label>
                                {!! Form::checkbox('show_never_opened',true,isset($filters['show_never_opened']) && $filters['show_never_opened']) !!}
                                Never opened
                            </label>
                        </div>
                    </div>
                </div>
                <div class="collapse" id="more-filters">
                    <div class="row">
                        <div class="col-sm-6">
                            @if(Auth::user()->can('see:all-organisations'))
                                <div class="form-group form-group-sm">
                                    {!! Form::label('organisation_id','Organisation',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                    <div class="col-sm-9">
                                        {!! Form::select('organisation_id',$organisations_list,isset($filters['organisation_id']) ? $filters['organisation_id'] : null,['class' => 'form-control not-chosen']) !!}
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group form-group-sm">
                                {!! Form::label('date_from','From',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('date_from',$dates_list, isset($filters['date_from']) ? $filters['date_from'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group form-group-sm">
                                {!! Form::label('date_to','To',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('date_to',$dates_list, isset($filters['date_to']) ? $filters['date_to'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('gender','Gender',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('gender',$genders, isset($filters['gender']) ? $filters['gender'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('ethnicity','Ethnicity',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('ethnicity',$ethnicities, isset($filters['ethnicity']) ? $filters['ethnicity'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('age','Age',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('age',$age_groups, isset($filters['age']) ? $filters['age'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('sexuality','Sexuality',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('sexuality',$sexualities, isset($filters['sexuality']) ? $filters['sexuality'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('how_they_heard','How they heard',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('how_they_heard',$how_they_heards, isset($filters['how_they_heard']) ? $filters['how_they_heard'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                            <div class="form-group form-group-sm">
                                {!! Form::label('referral_method','Referral method',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('referral_method',$referral_methods, isset($filters['referral_method']) ? $filters['referral_method'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                            <div class="form-group form-group-sm">
                                {!! Form::label('referral_source','Referral source',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('referral_source',$referral_sources, isset($filters['referral_source']) ? $filters['referral_source'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group form-group-sm">
                                {!! Form::label('journey_stage','Journey stage',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('journey_stage',$journey_stages, isset($filters['journey_stage']) ? $filters['journey_stage'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                            <div class="form-group form-group-sm">
                                {!! Form::label('cancer_type','Cancer type',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('cancer_type',$cancer_types, isset($filters['cancer_type']) ? $filters['cancer_type'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                            <div class="form-group form-group-sm">
                                {!! Form::label('advocacy_issue','Advocacy issue',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('advocacy_issue',$advocacy_issues, isset($filters['advocacy_issue']) ? $filters['advocacy_issue'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                            <div class="form-group form-group-sm">
                                {!! Form::label('advocacy_outcome','Advocacy outcome',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('advocacy_outcome',$advocacy_outcomes, isset($filters['advocacy_outcome']) ? $filters['advocacy_outcome'] : null,['class' => 'form-control not-chosen']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel-footer">
                <button type="submit" class="btn btn-primary search-button">
                    <i class="fa fa-fw fa-search"></i> Filter
                </button>
                @if(!empty($filters))
                    <button name="clear" value="clear" type="submit" class="btn btn-default search-button" style="float:right;">
                        <i class="fa fa-fw fa-times"></i> Reset filter
                    </button>
                @endif
                <button href="#more-filters" data-toggle="collapse" type="submit" class="btn btn-default search-button" style="float:right; margin-right:5px;">
                    <i class="fa fa-fw fa-sliders"></i> More filters
                </button>
            </div>
            {!! Form::close() !!}
        </div>
        {{--<ul class="nav nav-tabs">
            <li role="presentation" {!! Request::route()->getName() !== 'sam.service-user-cases.map' ? 'class="active"' : '' !!}><a href="{!! route('sculpt.index','service-user-cases') !!}"><i class="fa fa-fw fa-list"></i> List</a></li>
            <li role="presentation" {!! Request::route()->getName() == 'sam.service-user-cases.map' ? 'class="active"' : '' !!}><a href="{!! route('sam.service-user-cases.map','service-user-cases') !!}"><i class="fa fa-fw fa-map-marker"></i> Map</a></li>
        </ul>--}}
    @endif
@stop

@section('body-end')
    @parent
    <script>
        if($('#more-filters select option[selected][value!=""]').length) {
            $('#more-filters').show();
        }
    </script>
@stop

@section('table')
    <table class='table table-striped table-hover'>
        @section('table-head')
            <thead>
                <th>Case ID</th>
                <th>Service User Name</th>
                <th width="150">Status</th>
                <th>Date Opened</th>
                <th>Date Closed</th>
            </thead>
        @show
        @foreach($records as $record)
            <tr data-href="{{ route('sculpt.show',['service-user-cases',$record->id])  }}">
                @if($record->isActive())
                    <td>
                        #{!! $record->id !!}
                    </td>
                    <td>
                        {!! $record->service_user->name !!}
                    </td>
                    <td width="20" class="text-success">
                        <i class="fa fa-fw fa-folder-open-o"></i> Open
                    </td>
                    <td>
                        {!! $record->active_periods()->active()->first()->start->format('jS F Y') !!}
                    </td>
                    <td></td>
                @else
                    <td class="text-muted">
                        #{!! $record->id !!}
                    </td>
                    <td class="text-muted">
                        {!! $record->service_user->name !!}
                    </td>
                    <td width="20" class="text-warning">
                        <i class="fa fa-fw fa-folder-o"></i> Closed
                    </td>
                    @if($record->active_periods()->inactive()->count())
                        <td class="text-muted">
                            {!! $record->active_periods()->inactive()->first()->start->format('jS F Y') !!}
                        </td>
                        <td class="text-muted">
                            {!! $record->active_periods()->inactive()->first()->end->format('jS F Y') !!}
                        </td>
                    @else
                        <td colspan="2"><span class="text-muted">Never opened</span></td>
                    @endif
                @endif
            </tr>
        @endforeach
    </table>
@stop