<?php

Validator::extend('hasManyUnique', function($attribute, $value, $parameters) {
    $i = 0;
    $already_used = [];
    while($value = Input::get($attribute . ".$i." . $parameters[0])) {
        if(array_search($value, $already_used) === false) {
            $already_used[] = $value;
        } else {
            return false;
        }
        $i++;
    }
    return true;
});

Validator::extend('natureIdForCaseOrAdvocate', function($attribute, $nature_id)
{
    if(!$nature_id) {
        return true;
    } else {
        $nature = app('Concore\Personnel\Models\Nature');
        $type = $nature->find($nature_id)->type;
        if($type === 'both') {
            return true;
        }
        if(Input::has('activity.service_user_case_id')) {
            return $type === 'case';
        } else {
            return $type === 'advocate';
        }
    }
});

Validator::extend('timeslotTypesForCaseOrAdvocate', function($attribute)
{
    $i = 0;
    $type = Input::has('activity.service_user_case_id') ? 'case' : 'advocate';
    $available = config('sam.available-timeslot-types');
    while($value = Input::get($attribute . ".$i.timeslot.type")) {
        if(isset($available[$value]) && $available[$value] !== $type) {
            return false;
        }
        $i++;
    }
    return true;
});