<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdvocateServiceUserCaseTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('advocate_service_user_case',function(Blueprint $table) {
            $table->increments('id');
            $table->integer('advocate_id')->unsigned();
            $table->foreign('advocate_id')->references('id')->on('advocates')->onDelete('cascade');
            $table->integer('service_user_case_id')->unsigned();
            $table->foreign('service_user_case_id')->references('id')->on('service_user_cases')->onDelete('cascade');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::dropTable('advocate_service_user_case');
	}

}
