<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToServiceUserCasesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
            $table->string('advocacy_issues_other')->nullable()->after('service_user_id');
            $table->string('cancer_types_other')->nullable()->after('service_user_id');
            $table->string('how_heard_other')->nullable()->after('service_user_id');
            $table->enum('how_heard',['From the internet','Macmillan publication','Macmillan representative','National press','Local press','Posters\, flyers or leaflets','Cancer champion talks to local groups','Word of mouth'])->nullable()->after('service_user_id');
            $table->string('accommodation_type_other')->nullable()->after('service_user_id');
            $table->enum('accommodation_type',['Hospital','Own home alone','Own home with others','Nursing home','Staying with relatives or friends','Residential home','Sheltered accommodation'])->nullable()->after('service_user_id');
            $table->boolean('no_advocate_needed')->default(false)->after('service_user_id');
            $table->string('risk_assessment_score')->nullable()->after('service_user_id');
            $table->string('hospital_number')->nullable()->after('service_user_id');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::table('service_user_cases',function(Blueprint $table) {
            $table->dropColumn('advocacy_issues_other');
            $table->dropColumn('how_heard_other');
            $table->dropColumn('how_heard');
            $table->dropColumn('accommodation_type_other');
            $table->dropColumn('accommodation_type');
            $table->dropColumn('no_advocate_needed');
            $table->dropColumn('risk_assessment_score');
            $table->dropColumn('hospital_number');
            $table->dropColumn('cancer_types_other');
        });
	}

}
