<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddReferralMethodIdToServiceUserCases extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->string('referral_method_other')->nullable()->after('referral_source_other');
			$table->integer('referral_method_id')->nullable()->unsigned()->after('referral_source_other');
			$table->foreign('referral_method_id')->references('id')->on('referral_methods');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->dropColumn('journey_stage_id');
		});
	}

}
