@extends('sculpt::auto.index')

@section('filter-form')
    <div class="panel panel-default">
        {!! Form::open(['method' => 'get','class' => 'form-horizontal does-not-cause-unsaved-changes']) !!}
        <div class="panel-body" style="padding-bottom:0;">
            <div class="row">
                <div class="col-sm-5">
                    @if(Auth::user()->can('see:all-organisations'))
                        <div class="form-group">
                            {!! Form::label('organisation_id','Organisation',['class' => 'col-sm-4 control-label']) !!}
                            <div class="col-sm-8">
                                {!! Form::select('organisation_id',$organisations_list,isset($filters['organisation_id']) ? $filters['organisation_id'] : null,['class' => 'form-control']) !!}
                            </div>
                        </div>
                    @endif
                    <div class="form-group">
                        {!! Form::label('date_from','Date from',['class' => 'col-sm-4 control-label']) !!}
                        <div class="col-sm-8">
                            {!! Form::select('date_from',$dates_list,isset($filters['date_from']) ? $filters['date_from']: null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('date_to','Date to',['class' => 'col-sm-4 control-label']) !!}
                        <div class="col-sm-8">
                            {!! Form::select('date_to',$dates_list,isset($filters['date_to']) ? $filters['date_to']: null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-7">
                    <div class="form-group">
                        {!! Form::label('nature','Activity nature',['class' => 'col-sm-4 control-label']) !!}
                        <div class="col-sm-8">
                            {!! Form::select('nature',$natures_list,isset($filters['nature']) ? $filters['nature']: null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('timeslot_type','Activities involving',['class' => 'col-sm-4 control-label']) !!}
                        <div class="col-sm-8">
                            {!! Form::select('timeslot_type',$timeslot_types_list,isset($filters['timeslot_type']) ? $filters['timeslot_type']: null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel-footer">
            <button type="submit" class="btn btn-primary search-button">
                <i class="fa fa-fw fa-search"></i> Filter
            </button>
            @if(!empty($filters))
                <button name="clear" value="clear" type="submit" class="btn btn-default search-button" style="float:right;">
                    <i class="fa fa-fw fa-times"></i> Reset filter
                </button>
            @endif
        </div>
        {!! Form::close() !!}
    </div>
@stop

@section('table')
    @include('sculpt::activities.partials.table',['activities' => $records])
@stop