@section('tabs')
    @parent
    <div class="tab" data-tab-title="Next Activity">
        @if(isset($relation_fields['id']))
            <dl class='read-only'>
                @if ($related->nature)
                <dt>{{ Sculpt::getTrans('field-labels.nature_id') }}:</dt>
                <dd>{{ $related->nature->name }}</dd>
                @endif
                <dt>{{ Sculpt::getTrans('field-labels.date') }}:</dt>
                <dd>{{ $relation_fields['date']->value }}</dd>
                <dt>{{ Sculpt::getTrans('next-activity.field-labels.planned_action') }}:</dt>
                <dd>{{ $relation_fields['planned_action']->value }}</dd>
            </dl>
            <a class="btn btn-default" href="{{ route('sculpt.show', ['activities', $relation_fields['id']->value]) }}">{{ Sculpt::getTrans('next-activity.edit-button') }}</a>
        @else

            @if(old('next-activity'))

                <!-- Generated from old() input -->

                <div class="panel panel-default next-activity">
                    <div class="panel-body">
                        @if ($errors->has('next-activity.0.task.name'))
                            <div class="alert alert-danger">
                                <div class="row">
                                    <div class="col-sm-10">
                                        {{ Sculpt::getTrans('next-activity.cancel_unwanted_notice') }}
                                    </div>
                                    <div class="col-sm-2 text-right">
                                        <a href="#" class='remove-button no-warning'> {{ Sculpt::getTrans('next-activity.cancel-button') }}</a>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @include(Sculpt::getView('partials.forms.relation'),['relation' => 'nature','record' => $relation_model])
                        @include(Sculpt::getView('partials.forms.field'),['field'=>$relation_fields['date']])
                        @include(Sculpt::getView('partials.forms.field'),['field'=>$relation_fields['planned_action'],'label'=>Sculpt::getTrans('next-activity.field-labels.planned_action')])
                        <a href="#" class='btn btn-danger remove-button'><small><i class="fa fa-times"></i> {{ Sculpt::getTrans('next-activity.cancel-button') }}</small></a>
                    </div>
                </div>
            @endif

            @if(Auth::user()->can(['see:activities','see:activities-update']))
                    <p class="alert alert-warning">
                        You only need to add the next activity if it has been arranged.
                    </p>
                <a href="#" class="btn btn-default" id="next-activity-add-button">{{ Sculpt::getTrans('next-activity.add-button') }}</a>
            @endif

            <?php ob_start(); ?>
            <div class="panel panel-default next-activity">
                <div class="panel-body">
                    @include(Sculpt::getView('partials.forms.relation'),['relation' => 'nature','record' => $relation_model])
                    @include(Sculpt::getView('partials.forms.field'),['field'=>$relation_fields['date']])
                    @include(Sculpt::getView('partials.forms.field'),['field'=>$relation_fields['planned_action'],'label'=>Sculpt::getTrans('next-activity.field-labels.planned_action')])
                    <a href="#" class='btn btn-danger remove-button'><small><i class="fa fa-times"></i> {{ Sculpt::getTrans('next-activity.cancel-button') }}</small></a>
                </div>
            </div>
            <?php $output = ob_get_clean(); ?>
            <input id='new-relation-template-next-activity' value='{{ $output }}' type="hidden" />
        @endif
    </div>
@stop

@section('body-end')
    @parent
    <script>
        function checkAddButton() {
            if ($('.panel.next-activity').length) {
                $('#next-activity-add-button').hide();
            }
            else {
                $('#next-activity-add-button').show();
            }
        }
        checkAddButton();
        function bindRemoveButton() {
            $('.panel.next-activity').find('.remove-button').click(function(e) {
                e.preventDefault();
                if ($(this).hasClass('no-warning')) {
                    $('.panel.next-activity').remove();
                    checkAddButton();
                }
                else {
                    if(confirm('Are you sure you want to remove this? The information you entered in this activity will be lost.')) {
                        $('.panel.next-activity').remove();
                        checkAddButton();
                    }
                }
            });
        }
        bindRemoveButton();
        $('#next-activity-add-button').click(function(e) {
            e.preventDefault();
            var html = $(this).next().val();
            var $element = $(html);
            $element.insertBefore($(this));
            bindRemoveButton();
            checkAddButton();
            runFormPlugins($element);
        });
    </script>
@stop