@extends('sculpt!::dashboard')

@section('content')

    <h1>Welcome to SAM</h1>

    <div class="modal fade" tabindex="-1" role="dialog" id="welcome-modal" data-modal-number="8">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">SAM Update - 11th July</h4>
                </div>
                <div class="modal-body">
                    <p>Hi, {{ Auth::user()->employee ? Auth::user()->employee->person->preferred_name ? Auth::user()->employee->person->preferred_name : Auth::user()->employee->person->first_name : Auth::user()->independent->name }}</p>
                    <p>
                        We are about to implement increased security measures on SAM. The first of these is a more secure password policy and login process. We are aware that increased security often comes with inconvenience for users, so we have endeavoured to reduce this where possible.
                    </p>
                    <h4>Verify Your Identity</h4>
                    <p>
                        Soon you will be required to verify your identity every so often while using SAM. This is a simple process and doesn't require any questions or answers from you.
                    </p>
                    <ul>
                        <li>The first time you login to SAM after the changes have been implemented you will need to verify your identity. SAM will send you an email with a link in it, and if you just click the link you will be brought back to the site and logged in automatically. No need to re-enter or reset your password.</li>
                        <li>When you come to login after that you will be able to login as normal with your email and password.</li>
                        <li>After 3 months, you will be required to verify your identity once again. This is done in the same way: login, receive email, click link in email, done.</li>
                        <li>If you attempt to use SAM on a new device (i.e. a new or different computer, smartphone, tablet, etc) you will also need to verify your identity on that device. This is done in the same way.</li>
                    </ul>
                    <p>
                        The above changes will come into effect sometime next week (week commencing 18th July 2016).
                    </p>
                    <h4>Password Policy</h4>
                    <p>
                        We have also increased the security on the types of passwords that can be used with our new password policy. Over the coming weeks <strong>you will be required to reset your password</strong> so that it is in accordance with this policy. You will only need to do this once. You will receive a notice about this in due course.
                    </p>
                </div>
                <div class="modal-footer" style="text-align:left;margin-top:0;">
                    <button type="button" class="btn btn-primary" id="welcome-modal-button" data-dismiss="modal">Take me to SAM</button>
                </div>
            </div>
        </div>
    </div>
    @section('body-end')
        @parent
        <script>
            $modal = $('#welcome-modal');
            if(typeof Cookies.get('last-welcome-modal-seen') === 'undefined' || Cookies.get('last-welcome-modal-seen') < $modal.attr('data-modal-number')) {
                setTimeout(function() {
                    $('#welcome-modal').modal();
                },500);
                $('#welcome-modal-button').on('click', function (e) {
                    Cookies.set('last-welcome-modal-seen',$modal.attr('data-modal-number'));
                });
            }
        </script>
    @stop

    @if(count($reminders))
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Reminders
                </h3>
            </div>
            @include('reminders::list',['reminders' => $reminders])
        </div>
    @endif

    @if(count($recent_activities))
        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title">Recent Activities</h3>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:activities','see:activities-show']))
                            <a href="{{ route('sculpt.index','activities') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all activities</a>
                        @endif
                        @if(Auth::user()->can(['see:activities','see:activities-create']))
                            <a href="{{ route('sculpt.create','activities') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New activity</a>
                        @endif
                    </div>
                </div>
            </div>
            @include('sculpt::activities.partials.table',['activities' => $recent_activities])
        </div>
    @endif

    @if(Auth::user()->can('see:all-cases'))

        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title" style="display:inline-block;">
                    <i class="fa fa-fw fa-warning"></i>
                    {{ singular_plural(count($cases_without_advocates),'Unassigned Case','Unassigned Cases') }}
                </h3>
                <span data-toggle="popover" data-trigger="hover" data-content="<p>This shows cases that are open or have yet to be opened with no advocate(s) assigned. Cases that have been open and later closed are not shown, nor are cases with 'No advocate needed' checked.</p><p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </div>
            @if(count($cases_without_advocates))
                @include('sculpt::service-user-cases.partials.table',['cases' => $cases_without_advocates,'classes' => 'table-condensed'])
            @else
                <div class="panel-body">
                    No unassigned cases.
                </div>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:employees'))

        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title" style="display:inline-block;">Caseload</h3>
                        <span data-toggle="popover" data-trigger="hover" data-content="<p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p><p>Average cases per advocate: {{ round($average_cases_per_advocate,0) }}</p>" class="text-muted">
                            <i class="fa fa-fw fa-info-circle"></i>
                        </span>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-show']))
                            <a href="{{ route('sculpt.index','service-user-cases') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all cases</a>
                        @endif
                        @if(Auth::user()->can(['see:service-users','see:service-users-create']))
                            <a href="{{ route('sculpt.create','service-users') }}" class="btn btn-default btn-sm"><i class="fa fa-plus"></i> New service user</a>
                        @endif
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-create']))
                            <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New case</a>
                        @endif
                    </div>
                </div>
            </div>
            @if(count($advocates_with_cases))
                <div class="row" style="margin:0;">
                    <?php $i = 1; ?>
                    @foreach($advocates_with_cases as $advocate)
                        <?php $open_cases = $advocate->cases; ?>
                        <div class="col-sm-6" style="padding:0;{!! $i % 2 === 1 ? " clear:both;" : '' !!}">
                            <table class="table" style="margin-bottom:0;">
                                <thead>
                                    <tr>
                                        <th colspan="6">
                                            <a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a>
                                            ({{ singular_plural(count($open_cases), 'open case', 'open cases') }})
                                            <?php $days = $advocate->employee->user->daysSinceLastActivity(); ?>
                                            @if($days)
                                                <small data-toggle="tooltip" title="{{ $advocate->employee->person->preferred_name ?: $advocate->employee->person->first_name }}'s last activity was 3 days ago" class="text-muted" style="font-weight:normal; float:right; line-height:1.7;">
                                                    <i class="fa fa-fw fa-calendar-o"></i> {{ $days }} days ago
                                                </small>
                                            @endif
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php $j = 1; ?>
                                        @foreach($open_cases as $case)
                                            {!! $j % 2 === 1 ? "</tr><tr>" : '' !!}
                                            <td>
                                                <a href="{{ $case->getUrl() }}" style="color:inherit;"><small>{{ $case->name }}</small></a>
                                            </td>
                                            <td width="2px" align="right" style="padding:0;">
                                                <a style="padding:8px; display:block;" href="{{ route('sculpt.create',['activities','service_user_case_id' => $case->id]) }}" title="New activity for {{ $case->service_user->name }}">
                                                    <small class="text-muted">
                                                        <i class="fa fa-plus"></i>
                                                    </small>
                                                </a>
                                            </td>
                                            <td width="40px" align="right" style="padding-left:0px;">
                                                <?php $days = $case->daysSinceLastActivity(); ?>
                                                @if($days)
                                                    <small class="text-muted" data-toggle="tooltip" title="{{ $case->service_user->person->preferred_name ?: $case->service_user->person->first_name }}'s last activity was {{ $days }} days ago">
                                                        <i class="fa fa-calendar-o" style="margin-right:2px;"></i>
                                                        {{ $days }}
                                                    </small>
                                                @endif
                                            </td>
                                            <?php $j++; ?>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <?php $i++; ?>
                    @endforeach
                </div>
            @else
                <div class="panel-body">
                    No active advocates with open cases.
                </div>
            @endif
            @if(count($advocates_without_cases))
                <table class="table text-muted">
                    <thead>
                        <tr>
                            <th colspan="4">{{ singular_plural(count($advocates_without_cases),'active advocate','active advocates') }} with no open cases</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <?php $k = 1; ?>
                            @foreach($advocates_without_cases as $advocate)
                                {!! $k % 4 === 1 ? "</tr><tr>" : '' !!}
                                <td width="25%"><a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a></td>
                                <?php $k++; ?>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:logged-in-users'))
        @include('sculpt::active-users')
    @endif

    @if(Auth::user()->can('see:all-cases') && AuditLog::has())
        <small class="text-muted">
            @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::paginate(10)])
        </small>
    @endif

@stop