<table class="table">
    <thead>
    <tr>
        <th>Opened</th>
        <th>Opened by</th>
        <th>Closed</th>
        <th>Closed by</th>
        <th width="150">Reason</th>
        <th>Duration</th>
    </tr>
    </thead>
    @if($record->active_periods()->inactive()->count())
        @foreach($record->active_periods()->inactive()->get() as $active_period)
            <tr>
                <td>{{ $active_period->start->format('jS F Y') }}</td>
                @if($active_period->activated_by)
                    <td>{{ $active_period->activated_by->name }}</td>
                @else
                    <td>
                        <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                    </td>
                @endif
                <td>{{ $active_period->end->format('jS F Y') }}</td>
                @if($active_period->deactivated_by)
                    <td>{{ $active_period->deactivated_by->name }}</td>
                @else
                    <td>
                        <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                    </td>
                @endif
                <td>{{ $active_period->reason ? $active_period->reason->name : '' }}</td>
                <td>{{ $active_period->length }} days</td>
            </tr>
        @endforeach
    @endif
    <?php $currently_active = $record->active_periods()->active()->first() ?: null; ?>
    @if($currently_active)
        <tr>
            <td>{{ $currently_active->start->format('jS F Y') }}</td>
            @if($activated_by = $record->active_periods()->active()->first()->activated_by)
                <td>{{ $activated_by->name }}</td>
            @else
                <td>
                    <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                </td>
            @endif
            <td>
                @if(Auth::user()->can('do:close-case'))
                    <a href="{{ route('active-periods.end',$currently_active->id) }}">Close case now</a>
                @endif
            </td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
    @endif
</table>