<?php

use Concore\Notes\Models\NoteType;
use Concore\Personnel\Models\ActivePeriodReason;
use Concore\Personnel\Models\ContactEntityType;
use Concore\Personnel\Models\Nature;
use Concore\Sam\Models\JourneyStage;
use Concore\Sam\Models\ReferralMethod;
use Concore\Sculpt\Models\Permission;
use Concore\Sam\Models\AdvocacyIssue;
use Concore\Sam\Models\AdvocateMotivation;
use Concore\Sam\Models\CancerType;
use Concore\Sam\Models\Sexuality;
use Concore\Sam\Models\AccommodationType;
use Concore\Sam\Models\ReferralSource;
use Concore\Sam\Models\AdvocacyOutcome;
use Concore\Sculpt\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class SamDatabaseSeeder extends Seeder {

    /**
     * @var CancerType
     */
    private $cancer_type;
    /**
     * @var AdvocacyIssue
     */
    private $advocacy_issue;
    /**
     * @var Role
     */
    private $role;
    /**
     * @var ActivePeriodReason
     */
    private $active_period_reason;
    /**
     * @var NoteType
     */
    private $note_type;
    /**
     * @var AdvocateMotivation
     */
    private $advocate_motivation;
    /**
     * @var ContactEntityType
     */
    private $contact_entity_type;
    /**
     * @var PersonnelDatabaseSeeder
     */
    private $personnel_seeder;
    /**
     * @var Permission
     */
    private $permission;
    /**
     * @var Sexuality
     */
    private $sexuality;
    /**
     * @var AccommodationType
     */
    private $accommodation_type;
    /**
     * @var ReferralSource
     */
    private $referral_source;
    /**
     * @var Nature
     */
    private $nature;

    /**
     * @var AdvocacyOutcome
     */
    private $advocacy_outcome;
    /**
     * @var JourneyStage
     */
    private $journey_stage;
    /**
     * @var ReferralMethod
     */
    private $referral_method;

    public function __construct(
        PersonnelDatabaseSeeder $personnel_seeder,
        AdvocacyIssue $advocacy_issue,
        CancerType $cancer_type,
        Role $role,
        Permission $permission,
        ActivePeriodReason $active_period_reason,
        NoteType $note_type,
        AdvocateMotivation $advocate_motivation,
        ContactEntityType $contact_entity_type,
        Sexuality $sexuality,
        AccommodationType $accommodation_type,
        ReferralSource $referral_source,
        ReferralMethod $referral_method,
        Nature $nature,
        AdvocacyOutcome $advocacy_outcome,
        JourneyStage $journey_stage
    )
    {
        $this->personnel_seeder = $personnel_seeder;
        $this->cancer_type = $cancer_type;
        $this->advocacy_issue = $advocacy_issue;
        $this->role = $role;
        $this->active_period_reason = $active_period_reason;
        $this->note_type = $note_type;
        $this->advocate_motivation = $advocate_motivation;
        $this->contact_entity_type = $contact_entity_type;
        $this->permission = $permission;
        $this->sexuality = $sexuality;
        $this->accommodation_type = $accommodation_type;
        $this->referral_source = $referral_source;
        $this->nature = $nature;
        $this->advocacy_outcome = $advocacy_outcome;
        $this->journey_stage = $journey_stage;
        $this->referral_method = $referral_method;
    }

    protected function truncateAll() {
        $this->advocacy_issue->truncate();
        $this->cancer_type->truncate();
        $this->role->truncate();
        $this->active_period_reason->truncate();
        $this->note_type->truncate();
        $this->advocate_motivation->truncate();
        $this->contact_entity_type->truncate();
        $this->permission->truncate();
        $this->sexuality->truncate();
        $this->accommodation_type->truncate();
        $this->referral_source->truncate();
        $this->nature->truncate();
        $this->referral_method->truncate();
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $this->truncateAll();

        $this->personnel_seeder->run();

        $this->advocacy_issue->create(['name' => 'Access/iunvolvement']);
        $this->advocacy_issue->create(['name' => 'Accommodation']);
        $this->advocacy_issue->create(['name' => 'Appeals']);
        $this->advocacy_issue->create(['name' => 'Assessment']);
        $this->advocacy_issue->create(['name' => 'Benefits']);
        $this->advocacy_issue->create(['name' => 'Carer issues']);
        $this->advocacy_issue->create(['name' => 'Care provider']);
        $this->advocacy_issue->create(['name' => 'Complaints']);
        $this->advocacy_issue->create(['name' => 'Finances']);
        $this->advocacy_issue->create(['name' => 'Information']);
        $this->advocacy_issue->create(['name' => 'Isolation']);
        $this->advocacy_issue->create(['name' => 'Loneliness']);
        $this->advocacy_issue->create(['name' => 'Liaison with health professionals']);
        $this->advocacy_issue->create(['name' => 'Liaison other professionals']);
        $this->advocacy_issue->create(['name' => 'Mental health']);
        $this->advocacy_issue->create(['name' => 'Safeguarding']);
        $this->advocacy_issue->create(['name' => 'Social care']);
        $this->advocacy_issue->create(['name' => 'Treatment']);
        $this->advocacy_issue->create(['name' => 'Wellbeing - physical, health']);
        $this->advocacy_issue->create(['name' => 'Wellbeing - emotional']);
        $this->advocacy_issue->create(['name' => 'Transport']);
        $this->advocacy_issue->create(['name' => 'Practical support']);
        $this->advocacy_issue->create(['name' => 'Support to stay at home']);

        $this->cancer_type->create(['name' => "Anal"]);
        $this->cancer_type->create(['name' => "Bile duct (cholangiocarcinoma)"]);
        $this->cancer_type->create(['name' => "Bladder"]);
        $this->cancer_type->create(['name' => "Bone"]);
        $this->cancer_type->create(['name' => "Bowel"]);
        $this->cancer_type->create(['name' => "Brain tumours"]);
        $this->cancer_type->create(['name' => "Breast"]);
        $this->cancer_type->create(['name' => "Cervical"]);
        $this->cancer_type->create(['name' => "Colon and rectal"]);
        $this->cancer_type->create(['name' => "Endocrine tumours"]);
        $this->cancer_type->create(['name' => "Eye"]);
        $this->cancer_type->create(['name' => "Fallopian tube"]);
        $this->cancer_type->create(['name' => "Gall bladder"]);
        $this->cancer_type->create(['name' => "Head and neck"]);
        $this->cancer_type->create(['name' => "Kaposi's sarcoma"]);
        $this->cancer_type->create(['name' => "Kidney"]);
        $this->cancer_type->create(['name' => "Larynx"]);
        $this->cancer_type->create(['name' => "leukemia"]);
        $this->cancer_type->create(['name' => "Liver"]);
        $this->cancer_type->create(['name' => "Lung"]);
        $this->cancer_type->create(['name' => "Lymph node"]);
        $this->cancer_type->create(['name' => "Lymphoma"]);
        $this->cancer_type->create(['name' => "Melanoma"]);
        $this->cancer_type->create(['name' => "Mesothelioma"]);
        $this->cancer_type->create(['name' => "Myeloma"]);
        $this->cancer_type->create(['name' => "Neuroendocrine tumours"]);
        $this->cancer_type->create(['name' => "Oesophageal (gullet)"]);
        $this->cancer_type->create(['name' => "Ovarian"]);
        $this->cancer_type->create(['name' => "Pancreatic"]);
        $this->cancer_type->create(['name' => "Penis"]);
        $this->cancer_type->create(['name' => "Prostate"]);
        $this->cancer_type->create(['name' => "Pseudomyxoma peritonei"]);
        $this->cancer_type->create(['name' => "Skin"]);
        $this->cancer_type->create(['name' => "Small bowel"]);
        $this->cancer_type->create(['name' => "Soft tissue sarcomas"]);
        $this->cancer_type->create(['name' => "Spinal cord tumours"]);
        $this->cancer_type->create(['name' => "Stomach"]);
        $this->cancer_type->create(['name' => "Testicular"]);
        $this->cancer_type->create(['name' => "Thymus"]);
        $this->cancer_type->create(['name' => "Thyroid"]);
        $this->cancer_type->create(['name' => "Trachea (windpipe)"]);
        $this->cancer_type->create(['name' => "Unknown"]);
        $this->cancer_type->create(['name' => "Vagina"]);
        $this->cancer_type->create(['name' => "Vulva"]);
        $this->cancer_type->create(['name' => "Womb (endometrial)"]);

        // Roles

        $admin_role = $this->role->whereName('admin')->first();
        $technical_role = $this->role->whereName('technical')->first();

        $observer_role = $this->role->create([
            'name' => 'observer',
            'display_name' => 'Observer',
            'description' => 'User is allowed read-only access to all records in the system.'
        ]);
        $advocate_role = $this->role->create([
            'name' => 'advocate',
            'display_name' => 'Advocate',
            'description' => 'User is allowed to manage service users assigned to them.'
        ]);
        $coordinator_role = $this->role->create([
            'name' => 'coordinator',
            'display_name' => 'Coordinator',
            'description' => 'User is allowed to manage service users and advocates in their organisation.'
        ]);
        $cancer_champion_role = $this->role->create([
            'name' => 'cancer-champion',
            'display_name' => 'Cancer Champion',
            'description' => 'No additional privileges, just useful as a role for filtering and reporting.'
        ]);

        $manager_role = $this->role->where('name','=','manager')->first();
        $manager_role->fill([
            'display_name' => 'Local Administrator',
            'description' => 'User is allowed to manage all members of the local team in their organisation.'
        ]);
        $manager_role->save();

        $case_role = $this->role->create([
            'name' => 'service-user-case',
            'display_name' => 'Service User Case',
            'description' => 'This is a pseudo-role for cases, it is not selectable for employees or independents and thus no permissions are necessary.'
        ]);

        // Permissions

        $p_do_activate_all =                       $this->permission->create(['name' => 'do:activate-all',                     'display_name' => 'Activate all roles']);
        $p_do_activate_advocate =                  $this->permission->create(['name' => 'do:activate-advocate',                'display_name' => 'Activate advocate role']);
        $p_do_activate_cancer_champion =           $this->permission->create(['name' => 'do:activate-cancer-champion',         'display_name' => 'Activate cancer champion role']);
        $p_do_activate_coordinator =               $this->permission->create(['name' => 'do:activate-coordinator',             'display_name' => 'Activate coordinator role']);
        $p_do_deactivate_all =                     $this->permission->create(['name' => 'do:deactivate-all',                   'display_name' => 'Deactivate all roles']);
        $p_do_deactivate_advocate =                $this->permission->create(['name' => 'do:deactivate-advocate',              'display_name' => 'Deactivate advocate role']);
        $p_do_deactivate_cancer_champion =         $this->permission->create(['name' => 'do:deactivate-cancer-champion',       'display_name' => 'Deactivate cancer champion role']);
        $p_do_deactivate_coordinator =             $this->permission->create(['name' => 'do:deactivate-coordinator',           'display_name' => 'Deactivate coordinator role']);
        $p_do_change_permissions =                 $this->permission->create(['name' => 'do:change-permissions',               'display_name' => 'Change permissions for all roles']);
        $p_see_roles =                             $this->permission->create(['name' => 'see:roles',                           'display_name' => 'See all roles pages']);
        // Organisations
        $p_see_all_organisations =                 $this->permission->create(['name' => 'see:all-organisations',               'display_name' => 'See data for all organisations']);
        $p_see_organisations =                     $this->permission->create(['name' => 'see:organisations',                   'display_name' => 'See all organisations pages']);
        $p_do_change_assigned_organisations =      $this->permission->create(['name' => 'do:change-assigned-organisations',    'display_name' => 'Change assigned organisation']);
        // Service Users & Cases
        $p_see_service_users =                     $this->permission->create(['name' => 'see:service-users',                   'display_name' => 'See all service user pages']);
        $p_see_service_users_create =              $this->permission->create(['name' => 'see:service-users-create',            'display_name' => 'See create service user page']);
        $p_see_service_users_index =               $this->permission->create(['name' => 'see:service-users-index',             'display_name' => 'See service user index page']);
        $p_see_service_users_show =                $this->permission->create(['name' => 'see:service-users-show',              'display_name' => 'See individual service user page']);
        $p_see_service_users_store =               $this->permission->create(['name' => 'see:service-users-store',             'display_name' => 'Save new service users']);
        $p_see_service_users_update =              $this->permission->create(['name' => 'see:service-users-update',            'display_name' => 'Update existing service users']);
        $p_see_service_user_cases =                $this->permission->create(['name' => 'see:service-user-cases',              'display_name' => 'See all case pages']);
        $p_see_service_user_cases_create =         $this->permission->create(['name' => 'see:service-user-cases-create',       'display_name' => 'See create case page']);
        $p_see_service_user_cases_index =          $this->permission->create(['name' => 'see:service-user-cases-index',        'display_name' => 'See case index page']);
        $p_see_service_user_cases_show =           $this->permission->create(['name' => 'see:service-user-cases-show',         'display_name' => 'See individual case page']);
        $p_see_service_user_cases_store =          $this->permission->create(['name' => 'see:service-user-cases-store',        'display_name' => 'Save new cases']);
        $p_see_service_user_cases_update =         $this->permission->create(['name' => 'see:service-user-cases-update',       'display_name' => 'Update existing cases']);
        $p_see_own_cases =                         $this->permission->create(['name' => 'see:own-cases',                       'display_name' => 'Can see cases to which user is assigned']);
        $p_see_all_cases =                         $this->permission->create(['name' => 'see:all-cases',                       'display_name' => 'Can see all cases']);
        $p_do_open_case =                          $this->permission->create(['name' => 'do:open-case',                        'display_name' => 'Open cases']);
        $p_do_close_case =                         $this->permission->create(['name' => 'do:close-case',                       'display_name' => 'Close cases']);
        $p_do_change_case_advocates =              $this->permission->create(['name' => 'do:change-case-advocates',            'display_name' => 'Change advocates on cases']);
        $p_do_change_case_service_user =           $this->permission->create(['name' => 'do:change-case-service-user',         'display_name' => 'Change service users on cases']);
        $p_see_case_service_user_map =             $this->permission->create(['name' => 'see-route:sam.service-user-cases.map','display_name' => 'See the map of service user cases']);
        // Activities
        $p_see_activities =                        $this->permission->create(['name' => 'see:activities',                      'display_name' => 'See all activities pages']);
        $p_see_activities_index =                  $this->permission->create(['name' => 'see:activities-index',                'display_name' => 'See activity index page']);
        $p_see_activities_create =                 $this->permission->create(['name' => 'see:activities-create',               'display_name' => 'See create activity page']);
        $p_see_activities_show =                   $this->permission->create(['name' => 'see:activities-show',                 'display_name' => 'See individual activity page']);
        $p_see_activities_store =                  $this->permission->create(['name' => 'see:activities-store',                'display_name' => 'Save new activities']);
        $p_see_activities_update =                 $this->permission->create(['name' => 'see:activities-update',               'display_name' => 'Update existing activities']);
        $p_see_all_activities =                    $this->permission->create(['name' => 'see:all-activities',                  'display_name' => 'See all activities']);
        $p_do_activities_declare_others_present =  $this->permission->create(['name' => 'do:activities-declare-others-present','display_name' => 'Declare those other than self and assigned service users present']);
        $p_do_change_activity_creator =            $this->permission->create(['name' => 'do:change-activity-creator',          'display_name' => 'Change the user shown as creating the activity']);
        // Calendar & Reminders
        $p_see_route_calendar =                    $this->permission->create(['name' => 'see-route:calendar',                  'display_name' => 'See calendar page']);
        $p_see_route_calendar_feed =               $this->permission->create(['name' => 'see-route:calendar.feed',             'display_name' => 'See calendar events feed (required for calendar page)']);
        $p_see_reminders =                         $this->permission->create(['name' => 'see:reminders',                       'display_name' => 'See all reminders pages']);
        $p_see_reminders_index =                   $this->permission->create(['name' => 'see:reminders-index',                 'display_name' => 'See reminders index page']);
        $p_see_reminders_show =                    $this->permission->create(['name' => 'see:reminders-show',                  'display_name' => 'See individual reminder page']);
        $p_see_reminders_update =                  $this->permission->create(['name' => 'see:reminders-update',                'display_name' => 'See reminders update page']);
        $p_see_all_reminders =                     $this->permission->create(['name' => 'see:all-reminders',                   'display_name' => 'See all reminders']);
        $p_do_modify_reminders_by_others =         $this->permission->create(['name' => 'do:modify-reminders-by-others',       'display_name' => 'Modify reminders by others']);
        // Contacts
        $p_see_contact_entities =                  $this->permission->create(['name' => 'see:contact-entities',                'display_name' => 'See all contacts pages']);
        $p_add_contacts =                          $this->permission->create(['name' => 'do:add-contacts',                     'display_name' => 'Add contacts to people']);
        // Employees
        $p_see_employees =                         $this->permission->create(['name' => 'see:employees',                       'display_name' => 'See all employee pages']);
        $p_see_employees_index =                   $this->permission->create(['name' => 'see:employees-index',                 'display_name' => 'See employee index page']);
        $p_see_employees_create =                  $this->permission->create(['name' => 'see:employees-create',                'display_name' => 'See create employee page']);
        $p_see_employees_show =                    $this->permission->create(['name' => 'see:employees-show',                  'display_name' => 'See individual employee page']);
        $p_see_employees_store =                   $this->permission->create(['name' => 'see:employees-store',                 'display_name' => 'Save new employees']);
        $p_see_employees_update =                  $this->permission->create(['name' => 'see:employees-update',                'display_name' => 'Update existing employees']);
        $p_see_advocates =                         $this->permission->create(['name' => 'see:advocates',                       'display_name' => 'Attach advocate role data without activating the role']);
        $p_see_cancer_champions =                  $this->permission->create(['name' => 'see:cancer-champions',                'display_name' => 'Attach cancer champion role data without activating the role']);
        // Independents
        $p_see_independents =                      $this->permission->create(['name' => 'see:independents',                    'display_name' => 'See all independents pages']);
        // Other
        $p_see_logged_in_users =                   $this->permission->create(['name' => 'see:logged-in-users',                 'display_name' => 'See other logged in users']);
        $p_see_lookup_tables =                     $this->permission->create(['name' => 'see:lookup-tables',                   'display_name' => 'See all lookup table pages']);
        $p_see_identifying_information =           $this->permission->create(['name' => 'see:identifying-information',         'display_name' => 'See identifying information']);
        $p_restrict_read_only_access =             $this->permission->create(['name' => 'restrict:read-only-access',           'display_name' => 'Read-only access']);
        $p_see_route_audit_feed =                  $this->permission->create(['name' => 'see-route:audit.feed',                'display_name' => 'See audit log feed']);
        $p_see_route_active_periods_start =        $this->permission->create(['name' => 'see-route:active-periods.start',      'display_name' => 'See active periods start route']);
        $p_see_route_active_periods_end =          $this->permission->create(['name' => 'see-route:active-periods.end',        'display_name' => 'See active periods end route']);
        $p_see_contact_entity_types =              $this->permission->create(['name' => 'see:contact-entity-types',            'display_name' => 'See all contact entity types pages']);
        $p_see_active_period_reasons =             $this->permission->create(['name' => 'see:active-period-reasons',           'display_name' => 'See all active period reasons pages']);
        $p_see_journey_stages =                    $this->permission->create(['name' => 'see:journey-stages',                  'display_name' => 'See all journey stages pages']);
        $p_see_note_types =                        $this->permission->create(['name' => 'see:note-types',                      'display_name' => 'See all note typespages']);
        $p_see_cancer_types =                      $this->permission->create(['name' => 'see:cancer-types',                    'display_name' => 'See all cancer types pages']);
        $p_see_advocacy_issues =                   $this->permission->create(['name' => 'see:advocacy-issues',                 'display_name' => 'See all advocacy issues pages']);
        $p_see_advocacy_outcomes =                 $this->permission->create(['name' => 'see:advocacy-outcomes',               'display_name' => 'See all advocacy outcomes pages']);
        $p_see_advocate_motivations =              $this->permission->create(['name' => 'see:advocate-motivations',            'display_name' => 'See all advocate motivations pages']);
        // Reports
        $p_see_reports =                           $this->permission->create(['name' => 'see-route:report',                    'display_name' => 'See report pages']);
        $p_export_reports =                        $this->permission->create(['name' => 'see-route:report.export',             'display_name' => 'Export reports']);
        // Reset other users' passwords
        $p_reset_passwords =                       $this->permission->create(['name' => 'see-route:sculpt.reset-user-password','display_name' => "Reset other users' passwords"]);

        // Attach permissions to roles

        $admin_role->perms()->sync([
            $p_do_activate_all->id,
            $p_do_deactivate_all->id,
            $p_see_roles->id,
            $p_see_organisations->id,
            $p_see_service_users->id,
            $p_see_service_user_cases->id,
            $p_see_activities->id,
            $p_see_reminders->id,
            $p_see_contact_entities->id,
            $p_see_employees->id,
            $p_see_advocates_store,
            $p_see_cancer_champions_store,
            $p_see_independents->id,
            $p_see_lookup_tables->id,
            $p_see_logged_in_users->id,
            $p_see_all_cases->id,
            $p_see_all_activities->id,
            $p_see_identifying_information->id,
            $p_see_all_organisations->id,
            $p_see_route_calendar->id,
            $p_see_route_calendar_feed->id,
            $p_do_change_assigned_organisations->id,
            $p_do_open_case->id,
            $p_do_close_case->id,
            $p_do_change_case_advocates->id,
            $p_do_change_case_service_user->id,
            $p_do_change_activity_creator->id,
            $p_add_contacts->id,
            $p_see_route_audit_feed->id,
            $p_do_modify_reminders_by_others->id,
            $p_see_all_reminders->id,
            $p_see_contact_entity_types->id,
            $p_see_active_period_reasons->id,
            $p_see_journey_stages->id,
            $p_see_note_types->id,
            $p_see_cancer_types->id,
            $p_see_advocacy_issues->id,
            $p_see_advocacy_outcomes->id,
            $p_see_advocate_motivations->id,
            $p_see_reports->id,
            $p_export_reports->id
        ]);

        $technical_role->perms()->sync([
            $p_do_change_permissions->id
        ]);

        $observer_role->perms()->sync([
            $p_see_all_organisations->id,
            $p_see_service_users_index->id,
            $p_see_service_users_show->id,
            $p_see_service_user_cases_index->id,
            $p_see_service_user_cases_show->id,
            $p_see_activities_index->id,
            $p_see_activities_show->id,
            $p_see_route_calendar->id,
            $p_see_route_calendar_feed->id,
            $p_see_reminders_index->id,
            $p_see_reminders_show->id,
            $p_see_employees_index->id,
            $p_see_employees_show->id,
            $p_see_all_cases->id,
            $p_see_all_activities->id,
            $p_see_all_reminders->id,
            $p_restrict_read_only_access->id,
            $p_see_reports->id,
            $p_export_reports->id
        ]);

        $advocate_role->perms()->sync([
            $p_see_service_users_index->id,
            $p_see_service_users_show->id,
            $p_see_service_users_update->id,
            $p_see_service_user_cases_index->id,
            $p_see_service_user_cases_show->id,
            $p_see_service_user_cases_update->id,
            $p_see_activities->id,
            $p_see_route_calendar_feed->id,
            $p_see_route_calendar->id,
            $p_see_reminders_index->id,
            $p_see_reminders_show->id,
            $p_see_logged_in_users->id,
            $p_see_own_cases->id,
            $p_see_identifying_information->id,
            $p_see_route_audit_feed->id,
            $p_see_reminders_update->id,
            $p_see_case_service_user_map->id
        ]);

        $coordinator_permissions = [
            $p_do_activate_advocate->id,
            $p_do_activate_cancer_champion->id,
            $p_do_deactivate_advocate->id,
            $p_do_deactivate_cancer_champion->id,
            $p_see_service_users->id,
            $p_see_service_user_cases->id,
            $p_do_open_case->id,
            $p_do_close_case->id,
            $p_do_change_case_advocates->id,
            $p_do_change_case_service_user->id,
            $p_see_activities->id,
            $p_see_all_activities->id,
            $p_see_route_calendar->id,
            $p_see_route_calendar_feed->id,
            $p_see_reminders->id,
            $p_see_contact_entities->id,
            $p_see_employees->id,
            $p_see_advocates_store,
            $p_see_cancer_champions_store,
            $p_see_logged_in_users->id,
            $p_see_all_cases->id,
            $p_do_modify_reminders_by_others->id,
            $p_do_activities_declare_others_present->id,
            $p_see_identifying_information->id,
            $p_do_change_activity_creator->id,
            $p_add_contacts->id,
            $p_see_route_audit_feed->id,
            $p_see_all_reminders->id,
            $p_see_route_active_periods_start->id,
            $p_see_route_active_periods_end->id,
            $p_see_reports->id,
            $p_export_reports->id,
            $p_reset_passwords->id
        ];

        $coordinator_role->perms()->sync($coordinator_permissions);

        $manager_role->perms()->sync(array_merge($coordinator_permissions,[
            $p_do_activate_coordinator->id,
            $p_do_deactivate_coordinator->id
        ]));

        $cancer_champion_role->perms()->sync([
            // no permissions
        ]);

        // Active period reasons: advocates

        $this->active_period_reason->create([
            'name' => 'Role did not suit: advocate\'s decision',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Role did not suit: organisation\'s decision',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Moved on to paid work',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Moved on to volunteer work',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'No longer available to volunteer/work (not moved onto another position)',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Regular commitment too much',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Found training problematic',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Hours not regular enough',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Failed DBS Check',
            'role_id' => $advocate_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Other',
            'role_id' => $advocate_role->id
        ]);

        // Active period reasons: cases

        $this->active_period_reason->create([
            'name' => 'Passed away',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Issue resolved',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Empowered - client regained control',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Moved out of area',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Lost contact',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Service user too ill to access advocacy support',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Abuse of scheme',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Service user assessed and referred on',
            'role_id' => $case_role->id
        ]);
        $this->active_period_reason->create([
            'name' => 'Other',
            'role_id' => $case_role->id
        ]);

        $this->note_type->create(['name' => 'General']);
        $this->note_type->create(['name' => 'Signpost']);
        $this->note_type->create(['name' => 'Agreed to referral']);
        $this->note_type->create(['name' => 'Referral received']);
        $this->note_type->create(['name' => 'Agreed to support']);
        $this->note_type->create(['name' => 'Reference requested']);
        $this->note_type->create(['name' => 'Reference received']);
        $this->note_type->create(['name' => 'DBS check passed']);
        $this->note_type->create(['name' => 'Training received: Macmillan']);
        $this->note_type->create(['name' => 'Training received: Induction']);
        $this->note_type->create(['name' => 'Training received: OLGBT']);
        $this->note_type->create(['name' => 'Training received: SAM']);
        $this->note_type->create(['name' => 'Training received: Complex Cases']);
        $this->note_type->create(['name' => 'Training received: End of Life']);
        $this->note_type->create(['name' => 'Training received: Other']);

        $this->advocate_motivation->create(['name' => 'To help others with cancer']);
        $this->advocate_motivation->create(['name' => 'To give something back']);
        $this->advocate_motivation->create(['name' => 'To share knowledge and/or experience']);
        $this->advocate_motivation->create(['name' => 'To learn something new or gain new skills']);
        $this->advocate_motivation->create(['name' => 'To receive formal training']);
        $this->advocate_motivation->create(['name' => 'To help find employment']);
        $this->advocate_motivation->create(['name' => 'To offer specialist skills']);
        $this->advocate_motivation->create(['name' => 'Personal reasons']);

        $this->contact_entity_type->create(['name' => 'General']);
        $this->contact_entity_type->create(['name' => 'Next of kin']);
        $this->contact_entity_type->create(['name' => 'Emergency contact']);
        $this->contact_entity_type->create(['name' => 'Referrer']);
        $this->contact_entity_type->create(['name' => 'Previous employer']);
        $this->contact_entity_type->create(['name' => 'Previous volunteering']);
        $this->contact_entity_type->create(['name' => 'Reference']);

        // Sexualities

        $this->sexuality->create(['name' => 'Heterosexual (straight)']);
        $this->sexuality->create(['name' => 'Gay']);
        $this->sexuality->create(['name' => 'Lesbian']);
        $this->sexuality->create(['name' => 'Bisexual']);
        $this->sexuality->create(['name' => 'Would rather not say']);
        $this->sexuality->create(['name' => 'Unknown']);

        // Accommodation Types

        $this->accommodation_type->create(['name' => 'Hospital']);
        $this->accommodation_type->create(['name' => 'Own home alone']);
        $this->accommodation_type->create(['name' => 'Own home with others']);
        $this->accommodation_type->create(['name' => 'Nursing home']);
        $this->accommodation_type->create(['name' => 'Staying with relatives or friends']);
        $this->accommodation_type->create(['name' => 'Residential home']);
        $this->accommodation_type->create(['name' => 'Sheltered accommodation']);

        // Referral Sources

//        $this->referral_source->create(['name' => 'From the internet']);
//        $this->referral_source->create(['name' => 'Macmillan publication']);
//        $this->referral_source->create(['name' => 'Macmillan representative']);
//        $this->referral_source->create(['name' => 'National press']);
//        $this->referral_source->create(['name' => 'Local press']);
//        $this->referral_source->create(['name' => 'Posters, flyers or leaflets']);
//        $this->referral_source->create(['name' => 'Cancer champion talks to local groups']);
//        $this->referral_source->create(['name' => 'Word of mouth']);

        $this->referral_source->create(['name' => 'Self']);
        $this->referral_source->create(['name' => 'Family/friends']);
        $this->referral_source->create(['name' => 'Health professional']);
        $this->referral_source->create(['name' => 'Social care professional/social worker']);
        $this->referral_source->create(['name' => 'In-house - general enquiry']);
        $this->referral_source->create(['name' => 'Macmillan - local/regional']);
        $this->referral_source->create(['name' => 'Macmillan - helpline']);
        $this->referral_source->create(['name' => 'Other cancer contacts/support group']);
        $this->referral_source->create(['name' => 'Disability organisation']);
        $this->referral_source->create(['name' => 'Carers organisation']);
        $this->referral_source->create(['name' => 'CAB/advice agency']);
        $this->referral_source->create(['name' => 'Dementia advocacy']);
        $this->referral_source->create(['name' => 'LCCB']);
        $this->referral_source->create(['name' => 'Hospice/palliative care service']);
        $this->referral_source->create(['name' => 'Welfare rights']);
        $this->referral_source->create(['name' => 'Local community organisation']);

        // Referral Methods

        $this->referral_method->create(['name' => 'Telephone']);
        $this->referral_method->create(['name' => 'Email']);
        $this->referral_method->create(['name' => 'Webform']);
        $this->referral_method->create(['name' => 'In person']);
        $this->referral_method->create(['name' => 'By post']);
        $this->referral_method->create(['name' => 'Using Referral Pad']);

        // Journey Stages

        $this->journey_stage->create(['name' => 'Pre diagnosis']);
        $this->journey_stage->create(['name' => 'Newly diagnosed']);
        $this->journey_stage->create(['name' => 'Awaiting treatment or surgery']);
        $this->journey_stage->create(['name' => 'Undergoing treatment']);
        $this->journey_stage->create(['name' => 'Post treatment or remission']);
        $this->journey_stage->create(['name' => 'Palliative care']);
        $this->journey_stage->create(['name' => 'Treatment stopped']);
        $this->journey_stage->create(['name' => 'Bereaved (Carer)']);
        $this->journey_stage->create(['name' => 'Terminal']);
        $this->journey_stage->create(['name' => 'No Treatment']);
        $this->journey_stage->create(['name' => 'Unknown']);

        // Natures

        $this->nature->create(['name' => 'Independently researching information','type' => 'case']);
        $this->nature->create(['name' => 'Arranging services','type' => 'case']);
        $this->nature->create(['name' => 'Meeting/visit with service user: At home','type' => 'case']);
        $this->nature->create(['name' => 'Meeting/visit with service user: In hospital','type' => 'case']);
        $this->nature->create(['name' => 'Meeting/visit with service user: At office','type' => 'case']);
        $this->nature->create(['name' => 'Meeting/visit with service user: Other','type' => 'case']);
        $this->nature->create(['name' => 'Meeting with health professional: GP','type' => 'case']);
        $this->nature->create(['name' => 'Meeting with health professional: Consultant','type' => 'case']);
        $this->nature->create(['name' => 'Meeting with health professional: Clinical nurse specialist','type' => 'case']);
        $this->nature->create(['name' => 'Meeting with health professional: Occupational therapist','type' => 'case']);
        $this->nature->create(['name' => 'Meeting with health professional: Other','type' => 'case']);
        $this->nature->create(['name' => 'Meeting general: Social care professional','type' => 'case']);
        $this->nature->create(['name' => 'Meeting general: Solicitor','type' => 'case']);
        $this->nature->create(['name' => 'Meeting general: DWP','type' => 'case']);
        $this->nature->create(['name' => 'Meeting general: Other','type' => 'case']);
        $this->nature->create(['name' => 'Providing support: Emotional','type' => 'case']);
        $this->nature->create(['name' => 'Providing support: General','type' => 'case']);
        $this->nature->create(['name' => 'Referrals: First meeting with service user','type' => 'case']);
        $this->nature->create(['name' => 'Referrals: Introductory meeting with advocate','type' => 'case']);
        $this->nature->create(['name' => 'Referrals: Other','type' => 'case']);
        $this->nature->create(['name' => 'Signposting','type' => 'case']);
        $this->nature->create(['name' => 'Research/information gathering','type' => 'case']);
        $this->nature->create(['name' => 'Pre-allocation tasks','type' => 'case']);

        $this->nature->create(['name' => 'Introductory meeting','type' => 'advocate']);
        $this->nature->create(['name' => 'Shadowing','type' => 'advocate']);
        $this->nature->create(['name' => 'Training','type' => 'advocate']);
        $this->nature->create(['name' => 'Supervision/support','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: Macmillan','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: Induction','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: OLGBT','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: SAM','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: Complex Cases','type' => 'advocate']);
        $this->nature->create(['name' => 'OPAAL Training: End of life','type' => 'advocate']);

        // Advocacy Outcomes

        $this->advocacy_outcome->create(['name' => 'Understand and access treatment']);
        $this->advocacy_outcome->create(['name' => 'Understand and access care services']);
        $this->advocacy_outcome->create(['name' => 'Improved financial situation']);
        $this->advocacy_outcome->create(['name' => 'Improve knowledge and understanding']);
        $this->advocacy_outcome->create(['name' => 'Reduced isolation']);
        $this->advocacy_outcome->create(['name' => 'Expressed End of Life wishes']);
        $this->advocacy_outcome->create(['name' => 'Been treated with dignity and respect']);
        $this->advocacy_outcome->create(['name' => 'Involved in decision-making']);
        $this->advocacy_outcome->create(['name' => 'Those around me are better able to cope']);
        $this->advocacy_outcome->create(['name' => 'I am able to contribute more to my local community']);
        $this->advocacy_outcome->create(['name' => 'Improved health and emotional wellbeing']);
        $this->advocacy_outcome->create(['name' => 'Improved quality of life']);
        $this->advocacy_outcome->create(['name' => 'Reduced dependence on health services']);
        $this->advocacy_outcome->create(['name' => 'Increased access to support']);
        $this->advocacy_outcome->create(['name' => 'Increased confidence']);
        $this->advocacy_outcome->create(['name' => 'Increased/regained/maintained independence']);

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

    }

}