<?php namespace Concore\Sam\Handlers\Events;

use Concore\Personnel\Handlers\Events\LogActivePeriodEnded as ParentClass;
use Concore\Personnel\Events\ActivePeriodEnded;

class LogActivePeriodEnded extends ParentClass {

    /**
     * Handle the event.
     *
     * @param  RecordCreated  $event
     * @return void
     */
    public function handle(ActivePeriodEnded $event)
    {
        if ($this->is_of_type($event->attached_to,'Concore\Sam\Models\ServiceUserCase')) {
            $this->audit_log_service->put('closed-case',$event->attached_to);
        }
        else {
            parent::handle($event);
        }
    }

}

