<?php namespace Concore\Sam\Handlers\Events;

use Concore\Personnel\Handlers\Events\LogRecordDeleted as ParentClass;
use Concore\Sculpt\Events\RecordDeleted;

class LogRecordDeleted extends ParentClass {

    /**
     * Handle the event.
     *
     * @param  RecordDeleted  $event
     * @return void
     */
    public function handle(RecordDeleted $event)
    {
        if ($this->is_of_type($event->record,'\Concore\Notes\Models\Note')) {
            $note = $event->record;
            $item = false;
            $case = $note->service_user_cases->first();
            $person = $note->people->first();
            if ($case) {
                $item = $case;
            }
            elseif($person) {
                if ($person->employee) {
                    $item = $person->employee;
                }
                elseif ($person->service_user) {
                    $item = $person->service_user;
                }
            }
            if ($item) {
                $this->audit_log_service->put('deleted-note',$item);
            }
        }
        else {
            parent::handle($event);
        }
    }

}