<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Sam\Models\ServiceUserCase;
use Input, Session, Auth;
use Illuminate\Contracts\View\View;

class ServiceUserFormComposer {

    /**
     * @var ServiceUserCase
     */
    private $service_user_case;

    public function __construct(ServiceUserCase $service_user_case) {
        $this->service_user_case = $service_user_case;
    }

    public function compose(View $view) {
        $view_data = $view->getData();
        $service_user = $view_data['record'];
        $cases = [];
        $user = Auth::user();
        if($user->can('see:all-cases')) {
            $cases = $service_user->cases;
        } else if($user->hasRole('advocate') && $user->can('see:own-cases')) {
            $cases = $service_user->cases()->forAdvocate($user->employee->advocate->id)->get();
        }
        $view->with(compact('cases'));
    }

}