<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddJourneyStageIdToServiceUserCases extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->string('journey_stage_other')->nullable()->after('advocacy_issues_other');
            $table->integer('journey_stage_id')->nullable()->unsigned()->after('advocacy_issues_other');
			$table->foreign('journey_stage_id')->references('id')->on('journey_stages');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->dropColumn('journey_stage_id');
		});
	}

}
