<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddHowTheyHeardToCases extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->string('how_they_heard_other')->nullable()->after('journey_stage_other');
			$table->enum('how_they_heard',[
				"Previously used service",
				"From the internet",
				"Macmillan publication",
				"Macmillan representative",
				"Health professional",
				"Social care professional",
				"National press",
				"Local press",
				"Posters, flyers or leaflets",
				"Cancer champion talks to local groups",
				"Other voluntary organisation",
				"Word of mouth",
				"COPA staff",
				"COPA volunteer",
				"Unknown"
			])->nullable()->after('journey_stage_other');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('service_user_cases',function(Blueprint $table) {
			$table->dateColumn('how_they_heard');
			$table->dateColumn('how_they_heard_other');
		});
	}

}
