@extends('sculpt!::dashboard')

@section('content')

    <h1>Welcome to SAM</h1>

    <div class="modal fade" tabindex="-1" role="dialog" id="welcome-modal" data-modal-number="4">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">SAM Update - 18th April</h4>
                </div>
                <div class="modal-body">
                    <p>Hi, {{ Auth::user()->employee ? Auth::user()->employee->person->preferred_name ? Auth::user()->employee->person->preferred_name : Auth::user()->employee->person->first_name : Auth::user()->independent->name }}</p>
                    <p>
                        Some important changes have been made to the reporting in SAM. This should make filling out reports for OPAAL much quicker and easier.
                    </p>
                    <h5>Reporting Changes</h5>
                    <ul>
                        <li>The table at the top of each report showing 'Start of period', 'During period' and 'End of period' has been replaced with simpler figures. For example, total cases opened, total closed, total advocates added, etc.</li>
                        <li>On the Service User Cases report it is now possible to switch between all, simple and complex cases with the buttons at the bottom of the page.</li>
                        <li>Added a breakdown of hours support to cases - i.e. how many cases received between 0-9 hours support, how many between 9-17 etc.</li>
                        <li>Added a table to the Service User Cases report to show all cases added in the period along with their referral source, age and gender. In order to see this you'll need to run a report for one month only - e.g. March 2016 - March 2016.</li>
                        <li>Added table to advocates reports to show all advocates added and their training status and caseload. For more info on adding training milestones, see <a href="/docs/notes/milestones">Milestones</a> in the Help & FAQ.</a></li>
                        <li>Removed the sidebar to allow wider display for more legible statistics, added coloured headers for easier scanning.</li>
                    </ul>
                    <h5>Other Changes</h5>
                    <p>It is also now possible to add data for a role before adding that role to a team member. For example, you can now add advocate information such as whether or not the advocate is paid or a volunteer, before you actually activate the role of an advocate. You can log supervision activities and add training milestones with advocates before they are activated, but you cannot assign them to a case until they are activated.</p>
                    <ul>
                        <li>Fixed bug where warning message on activities "This activity was added using a previous version of SAM" was being shown when it shouldn't be.</li>
                        <li>Fixed bug where contact preference wasn't saving on service users.</li>
                    </ul>
                    <p>Please continue to provide feedback and report problems, and we will maintain to find fixes and improvements to the system ongoing.</p>
                </div>
                <div class="modal-footer" style="text-align:left;margin-top:0;">
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Take me to SAM</button>
                </div>
            </div>
        </div>
    </div>
    @section('body-end')
        @parent
        <script>
            $modal = $('#welcome-modal');
            if(typeof Cookies.get('last-welcome-modal-seen') === 'undefined' || Cookies.get('last-welcome-modal-seen') < $modal.attr('data-modal-number')) {
                setTimeout(function() {
                    $('#welcome-modal').modal();
                },500);
                $('#welcome-modal').on('hidden.bs.modal', function (e) {
                    Cookies.set('last-welcome-modal-seen',$modal.attr('data-modal-number'));
                });
            }
        </script>
    @stop

    @if(count($reminders))
        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title">
                    Reminders
                </h3>
            </div>
            @include('reminders::list',['reminders' => $reminders])
        </div>
    @endif

    @if(count($recent_activities))
        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title">Recent Activities</h3>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:activities','see:activities-show']))
                            <a href="{{ route('sculpt.index','activities') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all activities</a>
                        @endif
                        @if(Auth::user()->can(['see:activities','see:activities-create']))
                            <a href="{{ route('sculpt.create','activities') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New activity</a>
                        @endif
                    </div>
                </div>
            </div>
            @include('sculpt::activities.partials.table',['activities' => $recent_activities])
        </div>
    @endif

    @if(Auth::user()->can('see:all-cases'))

        <div class="panel panel-warning">
            <div class="panel-heading">
                <h3 class="panel-title" style="display:inline-block;">
                    <i class="fa fa-fw fa-warning"></i>
                    {{ singular_plural(count($cases_without_advocates),'Unassigned Case','Unassigned Cases') }}
                </h3>
                <span data-toggle="popover" data-trigger="hover" data-content="<p>This shows cases that are open or have yet to be opened with no advocate(s) assigned. Cases that have been open and later closed are not shown, nor are cases with 'No advocate needed' checked.</p><p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </div>
            @if(count($cases_without_advocates))
                @include('sculpt::service-user-cases.partials.table',['cases' => $cases_without_advocates,'classes' => 'table-condensed'])
            @else
                <div class="panel-body">
                    No unassigned cases.
                </div>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:employees'))

        <div class="panel panel-info">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-sm-6" style="margin-top:5px;">
                        <h3 class="panel-title" style="display:inline-block;">Caseload</h3>
                        <span data-toggle="popover" data-trigger="hover" data-content="<p>This information updates every {{ config('sam.dashboard-cache-time') }} minutes.</p><p>Average cases per advocate: {{ round($average_cases_per_advocate,0) }}</p>" class="text-muted">
                            <i class="fa fa-fw fa-info-circle"></i>
                        </span>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-show']))
                            <a href="{{ route('sculpt.index','service-user-cases') }}" class="btn btn-default btn-sm"><i class="fa fa-list"></i> See all cases</a>
                        @endif
                        @if(Auth::user()->can(['see:service-users','see:service-users-create']))
                            <a href="{{ route('sculpt.create','service-users') }}" class="btn btn-default btn-sm"><i class="fa fa-plus"></i> New service user</a>
                        @endif
                        @if(Auth::user()->can(['see:service-user-cases','see:service-user-cases-create']))
                            <a href="{{ route('sculpt.create','service-user-cases') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> New case</a>
                        @endif
                    </div>
                </div>
            </div>
            @if(count($advocates_with_cases))
                <div class="row" style="margin:0;">
                    <?php $i = 1; ?>
                    @foreach($advocates_with_cases as $advocate)
                        <?php $open_cases = $advocate->cases; ?>
                        <div class="col-sm-6" style="padding:0;{!! $i % 2 === 1 ? " clear:both;" : '' !!}">
                            <table class="table" style="margin-bottom:0;">
                                <thead>
                                    <tr>
                                        <th colspan="6">
                                            <a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a>
                                            ({{ singular_plural(count($open_cases), 'open case', 'open cases') }})
                                            <?php $days = $advocate->employee->user->daysSinceLastActivity(); ?>
                                            @if($days)
                                                <small data-toggle="tooltip" title="{{ $advocate->employee->person->preferred_name ?: $advocate->employee->person->first_name }}'s last activity was 3 days ago" class="text-muted" style="font-weight:normal; float:right; line-height:1.7;">
                                                    <i class="fa fa-fw fa-calendar-o"></i> {{ $days }} days ago
                                                </small>
                                            @endif
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <?php $j = 1; ?>
                                        @foreach($open_cases as $case)
                                            {!! $j % 2 === 1 ? "</tr><tr>" : '' !!}
                                            <td>
                                                <a href="{{ $case->getUrl() }}" style="color:inherit;"><small>{{ $case->name }}</small></a>
                                            </td>
                                            <td width="2px" align="right" style="padding:0;">
                                                <a style="padding:8px; display:block;" href="{{ route('sculpt.create',['activities','service_user_case_id' => $case->id]) }}" title="New activity for {{ $case->service_user->name }}">
                                                    <small class="text-muted">
                                                        <i class="fa fa-plus"></i>
                                                    </small>
                                                </a>
                                            </td>
                                            <td width="40px" align="right" style="padding-left:0px;">
                                                <?php $days = $case->daysSinceLastActivity(); ?>
                                                @if($days)
                                                    <small class="text-muted" data-toggle="tooltip" title="{{ $case->service_user->person->preferred_name ?: $case->service_user->person->first_name }}'s last activity was {{ $days }} days ago">
                                                        <i class="fa fa-calendar-o" style="margin-right:2px;"></i>
                                                        {{ $days }}
                                                    </small>
                                                @endif
                                            </td>
                                            <?php $j++; ?>
                                        @endforeach
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <?php $i++; ?>
                    @endforeach
                </div>
            @else
                <div class="panel-body">
                    No active advocates with open cases.
                </div>
            @endif
            @if(count($advocates_without_cases))
                <table class="table text-muted">
                    <thead>
                        <tr>
                            <th colspan="4">{{ singular_plural(count($advocates_without_cases),'active advocate','active advocates') }} with no open cases</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <?php $k = 1; ?>
                            @foreach($advocates_without_cases as $advocate)
                                {!! $k % 4 === 1 ? "</tr><tr>" : '' !!}
                                <td width="25%"><a href="{{ $advocate->getUrl() }}" style="color:inherit;">{{ $advocate->name }}</a></td>
                                <?php $k++; ?>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            @endif
        </div>

    @endif

    @if(Auth::user()->can('see:logged-in-users'))
        @include('sculpt::active-users')
    @endif

    @if(Auth::user()->can('see:all-cases') && AuditLog::has())
        <small class="text-muted">
            @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::paginate(10)])
        </small>
    @endif

@stop