@extends('sculpt::auto.index')

@section('title')
    <h1>
        {!! Config::get('sculpt.icon-' . $model->getSlugged()) !!}
        @if(Auth::user()->can('see:all-organisations'))
            {{ Sculpt::getTrans('index-title',$model->getHumanReadablePlural()) }}
        @else
            {{ Auth::user()->employee->person->organisation->name }} Team
        @endif
    </h1>
@stop

@section('filter-form')
<div class="panel panel-default">
    {!! Form::open(['method' => 'get','class' => 'form-horizontal does-not-cause-unsaved-changes']) !!}
    <div class="panel-body" style="padding-bottom:0;">
        <div class="row">
            <div class="col-sm-2">
                <div class="form-group form-group-sm">
                    {!! Form::label('id','ID',['class' => 'col-sm-2 control-label']) !!}
                    <div class="col-sm-9">
                        {!! Form::text('id',isset($filters['id']) ? $filters['id'] : null,['class' => 'form-control']) !!}
                    </div>
                </div>
            </div>
            @if(Auth::user()->can('see:identifying-information'))
                <div class="col-sm-3">
                    <div class="form-group form-group-sm">
                        {!! Form::label('name','Name',['class' => 'col-sm-3 control-label']) !!}
                        <div class="col-sm-9">
                            {!! Form::text('name',isset($filters['name']) ? $filters['name'] : null,['class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
            @endif
            <div class="col-sm-5">
                <div class="form-group form-group-sm">
                    {!! Form::label('roles[]','Role',['class' => 'col-sm-2 control-label']) !!}
                    <div class="col-sm-10">
                        {!! Form::select('roles[]',$roles,isset($filters['roles']) ? $filters['roles'] : [],['class' => 'form-control','multiple' => true]) !!}
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group form-group-sm">
                    <div class="checkbox">
                        <label>
                            {!! Form::checkbox('active-only',true,isset($filters['active-only']) ? $filters['active-only'] : null) !!}
                            Active only
                        </label>
                    </div>
                </div>
            </div>
        </div>
        <div class="collapse" id="more-filters">
            <div class="row">
                <div class="col-sm-6">
                    @if(Auth::user()->can('see:all-organisations'))
                        <div class="form-group form-group-sm">
                            {!! Form::label('organisation_id','Organisation',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                            <div class="col-sm-9">
                                {!! Form::select('organisation_id',$organisations_list,isset($filters['organisation_id']) ? $filters['organisation_id'] : null,['class' => 'form-control not-chosen']) !!}
                            </div>
                        </div>
                    @endif
                </div>
                <div class="col-sm-3">
                    <div class="form-group form-group-sm">
                        {!! Form::label('date_from','From',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('date_from',$dates_list, isset($filters['date_from']) ? $filters['date_from'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group form-group-sm">
                        {!! Form::label('date_to','To',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('date_to',$dates_list, isset($filters['date_to']) ? $filters['date_to'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group form-group-sm">
                        {!! Form::label('gender','Gender',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('gender',$genders, isset($filters['gender']) ? $filters['gender'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                    <div class="form-group form-group-sm">
                        {!! Form::label('age','Age',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('age',$age_groups, isset($filters['age']) ? $filters['age'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group form-group-sm">
                        {!! Form::label('ethnicity','Ethnicity',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('ethnicity',$ethnicities, isset($filters['ethnicity']) ? $filters['ethnicity'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                    <div class="form-group form-group-sm">
                        {!! Form::label('advocate_type','Type',['class' => 'col-sm-3 control-label','style' => 'text-align:left; padding-top:3px;']) !!}
                        <div class="col-sm-9">
                            {!! Form::select('advocate_type',['' => '','Volunteer' => 'Volunteer','Paid' => 'Paid'], isset($filters['advocate_type']) ? $filters['advocate_type'] : null,['class' => 'form-control not-chosen']) !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="panel-footer">
        <button type="submit" class="btn btn-primary search-button">
            <i class="fa fa-fw fa-search"></i> Filter
        </button>
        @if(!empty($filters))
            <button name="clear" value="clear" type="submit" class="btn btn-default search-button" style="float:right;">
                <i class="fa fa-fw fa-times"></i> Reset filter
            </button>
        @endif
        <button href="#more-filters" data-toggle="collapse" type="submit" class="btn btn-default search-button" style="float:right; margin-right:5px;">
            <i class="fa fa-fw fa-sliders"></i> More filters
        </button>
    </div>
    {!! Form::close() !!}
</div>
@stop

@section('body-end')
    @parent
    <script>
        if($('#more-filters select option[selected][value!=""]').length) {
            $('#more-filters').show();
        }
    </script>
@stop

@section('table')
<table class='table table-striped table-hover'>
    @section('table-head')
    <thead>
    <th>Name</th>
    <th>Role(s)</th>
    @if(Auth::user()->can('see:all-organisations'))
        <th>Organisation</th>
    @endif
    </thead>
    @show
    @foreach($records as $record)
    <tr data-href="{{ route('sculpt.show',[$record->getSluggedPlural(),$record->id])  }}">
        <td>{!! $record->name !!}</td>
        <td>{!! $record->user && $record->user->roles->count() ? implode(', ',$record->user->allRoles()) : '<span class="text-muted">No active roles</span>' !!}</td>
        @if(Auth::user()->can('see:all-organisations'))
            <td>{{ $record->person->organisation->name }}</td>
        @endif
    </tr>
    @endforeach
</table>
@stop