<?php namespace Concore\Sam\Http\Middleware;

use Closure, Input;

class ParseDateInput {

    public function handle($request, Closure $next)
    {
        $input = [];
        if(Input::has('_token')) {
            $input['_token'] = Input::get('_token');
        }
        foreach(Input::except('_token') as $key => $value) {
            $new_key = $key;
            if (strpos($key,'>') !== false) {
                $new_key = str_replace('>','.',$key);
            }
            if (is_array($value)) {
                $value = $this->replaceSeparateDateFields($value);
            }
            array_set($input, $new_key, $value);
        }
        Input::replace($input);
        return $next($request);
    }

    private function replaceSeparateDateFields(Array $array) {
        $new_value = $array;
        $date_fields = [
            'date_year',
            'date_month',
            'date_day'
        ];
        if(count(array_intersect_key(array_flip($date_fields), $array)) === count($date_fields)) {
            if ($array['date_year'] == '' && $array['date_month'] == '' && $array['date_day'] == '') {
                $new_value = '';
            }
            else {
                $new_value = $array['date_year'].'-'.$array['date_month'].'-'.$array['date_day'];
            }
        }
        else {
            foreach($new_value as &$value) {
                if (is_array($value)) {
                    $value = $this->replaceSeparateDateFields($value);
                }
            }
        }
        return $new_value;
    }
}