<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Sam\Services\Sculpt\AdvocateService;
use Concore\Sam\Services\TasksService;
use Reminders, Auth, Cache;
use Carbon\Carbon;
use Concore\Sam\Services\Sculpt\ServiceUserCaseService;
use Illuminate\Contracts\View\View;

class DashboardComposer {

    private $task_service;
    private $service_user_case_service;
    /**
     * @var AdvocateService
     */
    private $advocate_service;

    public function __construct(TasksService $task_service, ServiceUserCaseService $service_user_case_service, AdvocateService $advocate_service) {

        $this->service_user_case_service = $service_user_case_service;
        $this->advocate_service = $advocate_service;
        $this->tasks_service = $task_service;
    }

    public function compose(View $view)
    {
        $cache_suffix = 'all';
        if(!Auth::user()->can('see:all-organisations')) {
            $cache_suffix = 'in-org-' . Auth::user()->getOrganisationId();
        }
        if(Auth::user()->can('see:employees')) {
            $active_advocates_ordered_by_open_cases = Cache::remember('dashboard.active_advocates_ordered_by_open_cases.' . $cache_suffix,config('sam.dashboard-cache-time'),function() {
                return $this->advocate_service->getActiveOrderedByOpenCases();
            });
            $view->with('advocates_with_cases', $active_advocates_ordered_by_open_cases);
            $open_cases = 0;
            foreach($active_advocates_ordered_by_open_cases as $advocate) {
                $open_cases += count($advocate->cases);
            }
            $average_cases_per_advocate = 0;
            if(count($active_advocates_ordered_by_open_cases) > 0) {
                $average_cases_per_advocate = $open_cases / count($active_advocates_ordered_by_open_cases);
            }
            $view->with('average_cases_per_advocate', $average_cases_per_advocate);
            $active_advocates_no_open_cases = Cache::remember('dashboard.active_advocates_no_open_cases.' . $cache_suffix,config('sam.dashboard-cache-time'),function() {
                return $this->advocate_service->getActiveNoOpenCases();
            });
            $view->with('advocates_without_cases', $active_advocates_no_open_cases);
        }
        if(Auth::user()->can('see:all-cases')) {
            $cases_without_advocates = Cache::remember('dashboard.open_cases_without_advocates.' . $cache_suffix,config('sam.dashboard-cache-time'),function() {
                return $this->service_user_case_service->getOpenWithoutAdvocate();
            });
            $view->with('cases_without_advocates',$cases_without_advocates);
        }
        $view->with('recent_activities',$this->tasks_service->getRecent());
        $view->with('reminders',Reminders::forRemindee(Auth::user(),Carbon::now()->addDays(3)));
    }

}