<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Role;
use Illuminate\Contracts\View\View;

class ServiceUserCaseFormComposer {
    /**
     * @var Role
     */
    private $role;

    public function __construct(Role $role) {
        $this->role = $role;
    }

    public function compose(View $view) {
        $role_id = $this->role->select('id')->where('name','=','service-user-case')->lists('id');
        $view->with('service_user_case_role_id',array_pop($role_id));
    }

}