<?php namespace Concore\Sam\Models;

use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class Advocate extends Model implements IdentifiableInterface {

    use IdentifiableTrait;

    public $guarded = ['id','created_at','updated_at'];

    public $relation_methods = ['motivations'];

    public $fields_with_other = ['motivations'];

    public function employee() {
        return $this->belongsTo(app('Concore\Personnel\Models\Employee'));
    }

    public function motivations() {
        return $this->belongsToMany(app('Concore\Sam\Models\AdvocateMotivation'));
    }

    public function cases() {
        return $this->belongsToMany(app('Concore\Sam\Models\ServiceUserCase'));
    }

    public function getOpenCases() {
        return $this->cases()->open()->get();
    }

    public function getNameAttribute() {
        return $this->employee->person->name;
    }

    public function scopeInOrganisation($query, $organisation_id) {
        return $query->whereHas('employee',function($query) use($organisation_id) {
            $query->whereHas('person',function($query) use($organisation_id) {
                $query->where('organisation_id','=',$organisation_id);
            });
        });
    }

    public function scopeNoOpenCases($query) {
        return $query->whereHas('cases',function($query) {
            $query->open();
        },'<',1);
    }

    public function scopeHasOpenCases($query) {
        return $query->whereHas('cases',function($query) {
            $query->open();
        });
    }

    public function scopeActive($query) {
        return $query->whereHas('employee',function($employee) {
            $employee->whereHas('active_periods', function($active_period) {
                $active_period
                    ->whereNull('end')
                    ->whereHas('role', function ($role) {
                        $role->where('name', '=', 'advocate');
                    });
            });
        });
    }

    public function getUrl() {
        return route('sculpt.show', ['employees', $this->employee->id]);
    }

}