<?php namespace Concore\Sam\Models;

use Auth, DB;

class Person extends \Concore\Personnel\Models\Person {

    public $relation_methods = ['organisation','notes','contact_entities','contact'];

    public function advocate() {
        return $this->hasOne(app('Concore\Sam\Models\Advocate'));
    }

    public function activities() {
        return $this->tasks()->orderBy('date','asc');
    }

    public function service_user() {
        return $this->hasOne(app('Concore\Sam\Models\ServiceUser'));
    }

    public function getNameAttribute() {
        $name = parent::getNameAttribute();
        if(!Auth::user()->can('see:identifying-information') && $this->service_user) {
            $name = 'Service User #' . $this->service_user->id;
        }
        return $name;
    }

    public function sexuality() {
        return $this->belongsTo(app('Concore\Sam\Models\Sexuality'));
    }

    public function save(array $data = array()) {
        if (isset($this->attributes['date_of_birth']) && !is_null($this->attributes['date_of_birth'])) {
            $this->attributes['age'] = $this->date_of_birth->diffInYears();
        }
        parent::save($data);
    }

    public function getEthnicities() {
        $type = DB::select( DB::raw("SHOW COLUMNS FROM people WHERE Field = 'ethnicity'") )[0]->Type;
        preg_match('/^enum\((.*)\)$/', $type, $matches);
        return array_map(function($value) {
            return trim($value,"'");
        },explode("','", $matches[1]));
    }

}