<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\ActivePeriod;

abstract class EmployeesReport extends MasterRoleReport
{

    protected $active_period;
    /**
     * @var Employee
     */
    protected $employee;

    protected $table = 'employees';

    protected $start_during_end_wording = [
        [
            'Active',
            'Never active',
            'Inactive'
        ],
        [
            'Activations',
            'Reactivations',
            'Added but not yet activated',
            'Deactivations'
        ],
        [
            'Active',
            'Never active',
            'Inactive'
        ]
    ];

    public function __construct(
        Employee $employee,
        ActivePeriod $active_period,
        Role $role
    ) {
        $this->active_period = $active_period;
        $this->employee = $employee;
        $this->model = $employee;
        $this->role = $role;
        $this->employee_role_id = $this->role->where('name','=',$this->role_name)->first(['id'])->id;
    }

    public function getTables() {
        if (!$this->tables) {

//            $tables['start_of_period_table'] = $this->getStartOfPeriodTable();
//            $tables['during_period_table'] = $this->getDuringPeriodTable();
//            $tables['end_of_period_table'] = $this->getEndOfPeriodTable();

            $tables['totals'] = $this->getTotalsTable();
            $tables['gender'] = $this->getGenderTable();
            $tables['ethnicity'] = $this->getEthnicityTable();
            $tables['age'] = $this->getAgeTable();
            $this->tables = $tables;

        }
        return $this->tables;
    }

    // Bases

    public function getBaseQueryBuilder() {

        $query = parent::getBaseQueryBuilder();

        $query = $this->applyRoleConstraints($query);

        return $query;

    }

    public function getActivePeriodQueryBuilder($where = null) {

        $query = parent::getActivePeriodQueryBuilder($where);

        $query = $query->where('active_periods.role_id','=',$this->role_id);

        return $query;

    }

    protected function joinToPeopleTable($query) {
        return $query->join('people', 'employees.person_id', '=', 'people.id');
    }

    protected function getBaseUrlArgs() {
        return [
            'employees',
            'organisation_id' => $this->organisation_id,
            'date_from' => $this->from->format('Y-m'),
            'date_to' => $this->to->format('Y-m')
        ];
    }

    // Tables

    public function getTotalsTable() {

        $total_activated = $this->getBaseQueryBuilder();

        $total_added = $this->getTable();
        $total_added = $this->applyOrganisationConstraints($total_added);
        $total_added = $this->applyRoleConstraints($total_added);
        $total_added = $total_added->where('employees.created_at','>',$this->from->format('Y-m-d'));

        return new Table(
            'Totals',
            [],
            [
                [
                    $this->totals_wording[0],
                    $total_activated->count()
                ],
                [
                    $this->totals_wording[1],
                    $total_added->count()
                ]
            ]
        );

    }

    public function getGenderTable() {

        $table = parent::getGenderTable();

        $ids = $this->ids;

        $table->setLinkMap(
            function($row_index) use($ids) {
                return route('sculpt.index',$this->getBaseUrlArgs() + [
                    'roles[]' => $this->employee_role_id,
                    'gender' => $ids[$row_index]
                ]);
            }
        );
        
        return $table;

    }

    public function getEthnicityTable() {

        $table = parent::getEthnicityTable();

        $table->setLinkMap(
            function($row_index, $row) {
                return route('sculpt.index',$this->getBaseUrlArgs() + [
                    'roles[]' => $this->employee_role_id,
                    'ethnicity' => $row->_ethnicity !== 'Undefined' ? $row->_ethnicity : 'undefined',
                ]);
            }
        );

        return $table;

    }

    public function getAgeTable() {

        $table = parent::getAgeTable();

        $table->setLinkMap(
            function($row_index, $row) {
                return route('sculpt.index',$this->getBaseUrlArgs() + [
                    'roles[]' => $this->employee_role_id,
                    'age' => $row['group'] !== 'Undefined' ? $row['group'] : 'undefined',
                ]);
            }
        );

        return $table;
    }

}