<?php namespace Concore\Sam\Reports\Traits;

trait SamReportableTrait {

    protected $organisation_id;

    public function setOrganisation($organisation_id) {
        $this->organisation_id = $organisation_id;
    }

    protected function formatDuration() {
        return function($input)
        {
            settype($input, 'integer');
            if ($input < 1) {
                return '0 min';
            }
            $hours = floor($input / 60);
            $minutes = ($input % 60);
            if ($hours < 1) {
                return sprintf('%d min', $minutes);
            }
            return sprintf('%d hr %d min', $hours, $minutes);
        };
    }

}