<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCancerTypeServiceUserCaseTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('cancer_type_service_user_case',function(Blueprint $table) {
            $table->integer('cancer_type_id')->unsigned();
            $table->foreign('cancer_type_id')->references('id')->on('cancer_types')->onDelete('cascade');
            $table->integer('service_user_case_id')->unsigned();
            $table->foreign('service_user_case_id')->references('id')->on('service_user_cases')->onDelete('cascade');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::dropTable('cancer_type_service_user_case');
	}

}
