<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPlannedActionAndNextActivityToTasksTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tasks',function(Blueprint $table) {
            $table->text('planned_action')->nullable()->after('nature_id');
            $table->integer('next_activity_id')->nullable()->unsigned()->after('id');
            $table->foreign('next_activity_id')->references('id')->on('tasks')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tasks',function(Blueprint $table) {
            $table->dropForeign('tasks_next_activity_id_foreign');
            $table->dropColumn('next_activity_id');
            $table->dropColumn('planned_action');
        });
    }

}
