<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToAdvocatesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('advocates',function(Blueprint $table) {
            $table->string('advocate_motivations_other')->nullable()->after('employee_id');
            $table->text('volunteering_experience')->nullable()->after('employee_id');
            $table->text('cancer_specific_experience')->nullable()->after('employee_id');
            $table->text('expectations')->nullable()->after('employee_id');
            $table->string('role')->nullable()->after('employee_id');
            $table->string('preferred_area_of_work')->nullable()->after('employee_id');
            $table->boolean('willing_to_take_part_in_training')->nullable()->after('employee_id');
            $table->text('available_times')->nullable()->after('employee_id');
            $table->string('how_did_they_hear_about_us')->nullable()->after('employee_id');
            $table->enum('type_of_advocate',['Volunteer','Paid'])->default('Volunteer')->after('employee_id');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::table('advocates',function(Blueprint $table) {
            $table->dropColumn('volunteering_experience');
            $table->dropColumn('cancer_specific_experience');
            $table->dropColumn('expectations');
            $table->dropColumn('role');
            $table->dropColumn('preferred_area_of_work');
            $table->dropColumn('willing_to_take_part_in_training');
            $table->dropColumn('available_times');
            $table->dropColumn('how_did_they_hear_about_us');
            $table->dropColumn('advocate_motivations_other');
        });
	}

}
