@extends('sculpt::layout')

@section('content')

    <h1>Lookup Tables</h1>

    <div class="panel panel-warning">
        <div class="panel-heading">
            <h3 class="panel-title"><i class="fa fa-exclamation-triangle"></i> Take care when editing existing values</h3>
        </div>
        <div class="panel-body">
            <p>Existing values should only be edited to amend spelling mistakes or alter phrasing/wording. <strong>Do not</strong> change existing values to entirely different values, as anywhere they've been selected already will change with it.</p>
            <p>If new values need to be made, they should be added as entirely new values.</p>
        </div>
    </div>

    <p>Edit lookup table values:</p>

    <ul>
        <li><a href="{{ route('sculpt.index','active-period-reasons') }}">Active Period Reasons</a></li>
        <li><a href="{{ route('sculpt.index','contact-entity-types') }}">Contact Types</a></li>
        <li><a href="{{ route('sculpt.index','note-types') }}">Note Types</a></li>
        <li><a href="{{ route('sculpt.index','cancer-types') }}">Cancer Types</a></li>
        <li><a href="{{ route('sculpt.index','advocacy-issues') }}">Advocacy Issues</a></li>
        <li><a href="{{ route('sculpt.index','journey-stages') }}">Journey Stages</a></li>
        <li><a href="{{ route('sculpt.index','advocacy-outcomes') }}">Advocacy Outcomes</a></li>
        <li><a href="{{ route('sculpt.index','advocate-motivations') }}">Advocate Motivations</a></li>
        @if(Auth::user()->can(['see:roles']))
            <li><a href="{{ route('sculpt.index','roles') }}">Roles & Permissions</a></li>
        @endif
    </ul>

@stop