@if(count($active_devices))
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Other Active Users</h3>
        </div>
        <div class="panel-body">
            <ul>
                @foreach($active_devices as $device)
                    <li>
                        @if($device->user && $device->user->employee)
                            @if(Config::get('sculpt.sessions.other_active_users.show_name'))
                                <a href="{{ $device->user->employee->getUrl() }}">{{ $device->user->name }}</a>
                            @else
                                <a href="{{ $device->user->employee->getUrl() }}">User #{{ $device->user_id }}</a>
                            @endif
                            at {{ $device->user->getOrganisation()->name }}
                        @endif
                        @if(Config::get('sculpt.sessions.other_active_users.show_last_active'))
                            @if(Auth::user()->hasRole('technical') || Config::get('sculpt.sessions.other_active_users.last_active_click_to_url'))
                                <a href="{{ $device->last_url }}"><small class="text-muted">last active {{ $device->last_active }}</small></a>
                            @else
                                <small class="text-muted">last active {{ $device->last_active }}</small>
                            @endif
                        @endif
                        @if(Auth::user()->hasRole('technical'))
                            <i class="fa fa-laptop text-muted" data-toggle="popover" data-trigger="hover" title="Device" data-content="<strong>IP:</strong> {{ $device->ip }}<br /><strong>UA string:</strong> {{ $device->ua_string }}"></i>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endif