@extends('sculpt::auto.create')

@section('title')
    <h1>Add new activity</h1>
@stop

@section('sidebar-back-button')
    @if(Auth::user()->can(['see:' . $model->getSluggedPlural(), 'see:' . $model->getSluggedPlural() . '-store']))
        <button class="btn btn-default btn-block show-loading" id="add-another">
            <i class="fa fa-fw fa-floppy-o"></i> Add activity, then add another
        </button>
    @endif
    @parent
@stop

@section('body-end')
    @parent
    <script>
        $('#add-another').click(function() {
            $('#main > form input[name=_redirect]').val('{{ route('sculpt.create','activities') }}');
            $('#main > form .update-button').trigger('click');
        });
    </script>
@stop