@if($record->id)
    @include(Sculpt::getView('partials.forms.field'),['field' => 'id'])
@endif
<?php
$show_address = $record->address && $record->address->latlng;
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">Contact Info</h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="{{ $show_address ? 'col-sm-4' : 'col-sm-6' }}">
                @include(Sculpt::getView('partials.forms.field'),['field' => 'email'])
                @include(Sculpt::getView('partials.forms.field'),['field' => 'phone1'])
                @include(Sculpt::getView('partials.forms.field'),['field' => 'phone2'])
                @include(Sculpt::getView('partials.forms.field'),['field' => 'contact_preference'])
            </div>
            <div class="{{ $show_address ? 'col-sm-4' : 'col-sm-6' }}">
                <label>Address</label>
                @include(Sculpt::getView('partials.forms.relations.to-one.inline'),['relation' => 'addresses','prefix' => ($prefix ? $prefix . '[addresses]' : 'addresses') . '[0][address]','force_prefix' => true])
            </div>
            @if($show_address)
                <div class="col-sm-4">
                    @include('geo::partials.map',['locations' => [$record],'height' => 250])
                    <p style="margin-top:15px; margin-bottom:0;" class="text-right"><a href="{{ $record->address->getDirectionsUrl() }}" target="_blank">Larger map or directions <i class="fa fa-angle-right"></i></a></p>
                </div>
            @endif
        </div>
    </div>
</div>