@section('form')
    <div class="tab active" data-tab-title="Case Status">
        @include('sculpt::service-user-cases.partials.forms.case-status')
    </div>
    <div class="tab" data-tab-title="Case Info">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Referral</h3>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-4">
                        @include(Sculpt::getView('partials.forms.relation'),['relation'=>'referral_source'])
                        @include(Sculpt::getView('partials.forms.field'),['field'=>'referral_source_other'])
                        @if($record->hasReferrerContactInfo() && Auth::user()->can('see:identifying-information'))
                            <p>See <a href="#" data-trigger="#tab-link-contacts">Contacts</a> for referrer contact information</p>
                        @endif
                    </div>
                    <div class="col-sm-4">
                        @include(Sculpt::getView('partials.forms.relation'),['relation'=>'referral_method'])
                        @include(Sculpt::getView('partials.forms.field'),['field'=>'referral_method_other'])
                    </div>
                    <div class="col-sm-4">
                        @include(Sculpt::getView('partials.forms.field'),['field'=>'how_they_heard'])
                        @include(Sculpt::getView('partials.forms.field'),['field'=>'how_they_heard_other'])
                    </div>
                </div>
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'journey_stage'])
                @include(Sculpt::getView('partials.forms.field'),['field'=>'journey_stage_other'])
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Key Info</h3>
            </div>
            <div class="panel-body">
                @include(Sculpt::getView('partials.forms.field'),['field'=>'case_type'])
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'advocacy_issues'])
                @include(Sculpt::getView('partials.forms.field'),['field'=>'advocacy_issues_other'])
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'cancer_types'])
                @include(Sculpt::getView('partials.forms.field'),['field'=>'cancer_types_other'])
            </div>
        </div>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Other Info</h3>
            </div>
            <div class="panel-body">
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'accommodation_type'])
                @include(Sculpt::getView('partials.forms.field'),['field'=>'accommodation_type_other'])
                @if(Auth::user()->can('see:identifying-information'))
                    @include(Sculpt::getView('partials.forms.field'),['field'=>'hospital_number'])
                    @include(Sculpt::getView('partials.forms.field'),['field'=>'risk_assessment_score'])
                @endif
            </div>
        </div>
    </div>
@stop

@section('tabs')
    @include(Sculpt::getView('partials.forms.relation'),['relation'=>'contact_entities'])
    @if (Auth::user()->can('see:identifying-information'))
        @include(Sculpt::getView('partials.forms.relation'),['relation'=>'notes'])
    @endif
    @if($record->id)
        <div class="tab" data-tab-title="Outcomes">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Advocacy Outcomes</h3>
                </div>
                <div class="panel-body">
                    @if(!$record->active_periods()->active()->count() && !$record->advocacy_outcomes->count())
                        <p class="alert alert-danger">
                            <i class="fa fa-fw fa-exclamation-circle"></i> For all closed cases <strong>please ensure advocacy outcomes are filled out</strong>
                            @if(in_array(config('sam.passed-away-reason-id'),array_pluck($record->active_periods()->inactive()->get()->toArray(),'active_period_reason_id')))
                                <br /><em>Since this service user has passed away, any outcomes declared on this case will be taken as the opinion of the advocate on behalf of the service user.</em>
                            @endif
                        </p>
                    @endif
                    @include(Sculpt::getView('partials.forms.relation'),['relation'=>'advocacy_outcomes'])
                </div>
            </div>
        </div>
        <div class="tab" data-tab-title="Activities">
            <h3>Activities</h3>
            <table class="table" style="margin-bottom:0;">
                <thead>
                    <th>{{ Sculpt::getTrans('field-labels.activities_number') }}</th>
                    <th>{{ Sculpt::getTrans('field-labels.activities_average_duration') }}</th>
                    <th>{{ Sculpt::getTrans('field-labels.activities_duration') }}</th>
                </thead>
                <tbody>
                <tr>
                    <td>{{ $record->activities->count() }}</td>
                    <td>
                        {{ floor($record->activities_average_duration / 60) . ':' . sprintf('%02d',ceil($record->activities_average_duration % 60)) }}
                    </td>
                    <td>
                        {{ floor($record->activities_duration / 60) . ':' . sprintf('%02d',ceil($record->activities_duration % 60)) }}
                    </td>
                </tr>
                </tbody>
            </table>
            @if(Auth::user()->can(['see:activities','see:activities-create']))
                <div class="form-group">
                    <a href="{{ route('sculpt.create',['activities']) }}" class="btn btn-default">{!! Config::get('sculpt.icon-task') !!} New activity</a>
                </div>
            @endif
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Activities for
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->service_user->person->preferred_name ?: $record->service_user->person->first_name }}
                        @else
                            {{ $record->service_user->getHumanReadable().' #'.$record->service_user->id }}
                        @endif
                    </h3>
                </div>
                <div class="panel-body">
                    <p>These activities were assigned to
                        @if (Auth::user()->can('see:identifying-information'))
                            {{ $record->service_user->person->preferred_name ?: $record->service_user->person->first_name }}'s
                        @else
                            {{ $record->service_user->getHumanReadable().' #'.$record->service_user->id }}'s
                        @endif
                     case.</p>
                    @include('sculpt::activities.partials.table',['activities' => $record->activities])
                </div>
            </div>
        </div>
        @if(Auth::user()->can('see-route:audit.feed'))
            <div class="tab" data-tab-title="Audit Log">
                @include('auditing::audit-logs-paginated', ['logs'=>AuditLog::forLoggeePaginated($record, 10),'loggee'=>$record])
            </div>
        @endif
    @endif
@stop
