@extends('sculpt::auto.show')

@section('title')
    <h1>
        <span>
            Showing case:
        </span>
        <i class="fa fa-fw {{ $record->isActive() ? 'fa-folder-open-o text-success' : 'fa-folder-o text-warning' }}"></i>
        {{ $record->name }}
    </h1>
@stop

@section('sidebar-case-info')
    @if($record->active_periods()->count() > 0)
        <a href="{{ route('sam.service-user-cases.story',['service-user-cases',$record->id]) }}" class="btn btn-default btn-block"><i class="fa fa-fw fa-file-text-o"></i> Case story</a>
    @endif
    @parent
@stop

@section('contacts-title')
    @if (!empty($record->service_user->person->contact->phone1) && !empty($record->service_user->person->address))
    <div class="alert alert-info">
        <strong>{{ $record->service_user->person->name }}</strong><br />
        @if (!empty($record->service_user->person->contact->phone1))
            <a href="tel:{{ $record->service_user->person->contact->phone1 }}"><i class="fa fa-fw fa-phone"></i> {{ $record->service_user->person->contact->phone1 }}</a>
        @endif
        @if (!empty($record->service_user->person->contact->phone2))
            <a href="tel:{{ $record->service_user->person->contact->phone2 }}"><i class="fa fa-fw fa-phone"></i> {{ $record->service_user->person->contact->phone2 }}</a>
        @endif
        @if (!empty($record->service_user->person->address))
            <a href="{{ $record->service_user->person->address->getDirectionsUrl() }}" target="_blank"><i class="fa fa-fw fa-map-marker"></i> {{ $record->service_user->person->address->toString() }}</a>
        @endif
    </div>
    @endif

    @parent
@stop